/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.io.Closeable;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import junit.framework.TestCase;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.component.bean.MyStaticClass;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.DefaultMessage;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.MyDummyObject;
import org.apache.camel.util.ObjectHelper;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ObjectHelperTest
extends TestCase {
    public void testLoadResourceAsStream() {
        InputStream res1 = ObjectHelper.loadResourceAsStream((String)"org/apache/camel/util/ObjectHelperResourceTestFile.properties");
        InputStream res2 = ObjectHelper.loadResourceAsStream((String)"/org/apache/camel/util/ObjectHelperResourceTestFile.properties");
        ObjectHelperTest.assertNotNull((String)"Cannot load resource without leading \"/\"", (Object)res1);
        ObjectHelperTest.assertNotNull((String)"Cannot load resource with leading \"/\"", (Object)res2);
        IOHelper.close((Closeable[])new Closeable[]{res1, res2});
    }

    public void testLoadResource() {
        URL url1 = ObjectHelper.loadResourceAsURL((String)"org/apache/camel/util/ObjectHelperResourceTestFile.properties");
        URL url2 = ObjectHelper.loadResourceAsURL((String)"/org/apache/camel/util/ObjectHelperResourceTestFile.properties");
        ObjectHelperTest.assertNotNull((String)"Cannot load resource without leading \"/\"", (Object)url1);
        ObjectHelperTest.assertNotNull((String)"Cannot load resource with leading \"/\"", (Object)url2);
    }

    public void testRemoveInitialCharacters() throws Exception {
        ObjectHelperTest.assertEquals((String)ObjectHelper.removeStartingCharacters((String)"foo", (char)'/'), (String)"foo");
        ObjectHelperTest.assertEquals((String)ObjectHelper.removeStartingCharacters((String)"/foo", (char)'/'), (String)"foo");
        ObjectHelperTest.assertEquals((String)ObjectHelper.removeStartingCharacters((String)"//foo", (char)'/'), (String)"foo");
    }

    public void testGetPropertyName() throws Exception {
        Method method = ((Object)((Object)this)).getClass().getMethod("setCheese", String.class);
        ObjectHelperTest.assertNotNull((String)"should have found a method!", (Object)method);
        String name = ObjectHelper.getPropertyName((Method)method);
        ObjectHelperTest.assertEquals((String)"Property name", (String)"cheese", (String)name);
    }

    public void setCheese(String cheese) {
    }

    public void testContains() throws Exception {
        String[] array = new String[]{"foo", "bar"};
        List<String> collection = Arrays.asList(array);
        ObjectHelperTest.assertTrue((boolean)ObjectHelper.contains((Object)array, (Object)"foo"));
        ObjectHelperTest.assertTrue((boolean)ObjectHelper.contains(collection, (Object)"foo"));
        ObjectHelperTest.assertTrue((boolean)ObjectHelper.contains((Object)"foo", (Object)"foo"));
        ObjectHelperTest.assertFalse((boolean)ObjectHelper.contains((Object)array, (Object)"xyz"));
        ObjectHelperTest.assertFalse((boolean)ObjectHelper.contains(collection, (Object)"xyz"));
        ObjectHelperTest.assertFalse((boolean)ObjectHelper.contains((Object)"foo", (Object)"xyz"));
    }

    public void testContainsStringBuilder() throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("Hello World");
        ObjectHelperTest.assertTrue((boolean)ObjectHelper.contains((Object)sb, (Object)"World"));
        ObjectHelperTest.assertTrue((boolean)ObjectHelper.contains((Object)sb, (Object)new StringBuffer("World")));
        ObjectHelperTest.assertTrue((boolean)ObjectHelper.contains((Object)sb, (Object)new StringBuilder("World")));
        ObjectHelperTest.assertFalse((boolean)ObjectHelper.contains((Object)sb, (Object)"Camel"));
        ObjectHelperTest.assertFalse((boolean)ObjectHelper.contains((Object)sb, (Object)new StringBuffer("Camel")));
        ObjectHelperTest.assertFalse((boolean)ObjectHelper.contains((Object)sb, (Object)new StringBuilder("Camel")));
    }

    public void testContainsStringBuffer() throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append("Hello World");
        ObjectHelperTest.assertTrue((boolean)ObjectHelper.contains((Object)sb, (Object)"World"));
        ObjectHelperTest.assertTrue((boolean)ObjectHelper.contains((Object)sb, (Object)new StringBuffer("World")));
        ObjectHelperTest.assertTrue((boolean)ObjectHelper.contains((Object)sb, (Object)new StringBuilder("World")));
        ObjectHelperTest.assertFalse((boolean)ObjectHelper.contains((Object)sb, (Object)"Camel"));
        ObjectHelperTest.assertFalse((boolean)ObjectHelper.contains((Object)sb, (Object)new StringBuffer("Camel")));
        ObjectHelperTest.assertFalse((boolean)ObjectHelper.contains((Object)sb, (Object)new StringBuilder("Camel")));
    }

    public void testEqual() {
        ObjectHelperTest.assertTrue((boolean)ObjectHelper.equal(null, null));
        ObjectHelperTest.assertTrue((boolean)ObjectHelper.equal((Object)"", (Object)""));
        ObjectHelperTest.assertTrue((boolean)ObjectHelper.equal((Object)" ", (Object)" "));
        ObjectHelperTest.assertTrue((boolean)ObjectHelper.equal((Object)"Hello", (Object)"Hello"));
        ObjectHelperTest.assertTrue((boolean)ObjectHelper.equal((Object)123, (Object)123));
        ObjectHelperTest.assertTrue((boolean)ObjectHelper.equal((Object)true, (Object)true));
        ObjectHelperTest.assertFalse((boolean)ObjectHelper.equal(null, (Object)""));
        ObjectHelperTest.assertFalse((boolean)ObjectHelper.equal((Object)"", null));
        ObjectHelperTest.assertFalse((boolean)ObjectHelper.equal((Object)" ", (Object)"    "));
        ObjectHelperTest.assertFalse((boolean)ObjectHelper.equal((Object)"Hello", (Object)"World"));
        ObjectHelperTest.assertFalse((boolean)ObjectHelper.equal((Object)true, (Object)false));
        ObjectHelperTest.assertFalse((boolean)ObjectHelper.equal((Object)new Object(), (Object)new Object()));
        byte[] a = new byte[]{40, 50, 60};
        byte[] b = new byte[]{40, 50, 60};
        ObjectHelperTest.assertTrue((boolean)ObjectHelper.equal((Object)a, (Object)b));
        a = new byte[]{40, 50, 60};
        b = new byte[]{40, 50, 60, 70};
        ObjectHelperTest.assertFalse((boolean)ObjectHelper.equal((Object)a, (Object)b));
    }

    public void testEqualByteArray() {
        ObjectHelperTest.assertTrue((boolean)ObjectHelper.equalByteArray((byte[])"Hello".getBytes(), (byte[])"Hello".getBytes()));
        ObjectHelperTest.assertFalse((boolean)ObjectHelper.equalByteArray((byte[])"Hello".getBytes(), (byte[])"World".getBytes()));
        ObjectHelperTest.assertTrue((boolean)ObjectHelper.equalByteArray((byte[])"Hello Thai Elephant \u0e08".getBytes(), (byte[])"Hello Thai Elephant \u0e08".getBytes()));
        ObjectHelperTest.assertTrue((boolean)ObjectHelper.equalByteArray(null, null));
        byte[] empty = new byte[]{};
        ObjectHelperTest.assertTrue((boolean)ObjectHelper.equalByteArray((byte[])empty, (byte[])empty));
        byte[] a = new byte[]{40, 50, 60};
        byte[] b = new byte[]{40, 50, 60};
        ObjectHelperTest.assertTrue((boolean)ObjectHelper.equalByteArray((byte[])a, (byte[])b));
        a = new byte[]{40, 50, 60};
        b = new byte[]{40, 50, 60, 70};
        ObjectHelperTest.assertFalse((boolean)ObjectHelper.equalByteArray((byte[])a, (byte[])b));
        a = new byte[]{40, 50, 60, 70};
        b = new byte[]{40, 50, 60};
        ObjectHelperTest.assertFalse((boolean)ObjectHelper.equalByteArray((byte[])a, (byte[])b));
        a = new byte[]{40, 50, 60};
        b = new byte[]{};
        ObjectHelperTest.assertFalse((boolean)ObjectHelper.equalByteArray((byte[])a, (byte[])b));
        a = new byte[]{};
        b = new byte[]{40, 50, 60};
        ObjectHelperTest.assertFalse((boolean)ObjectHelper.equalByteArray((byte[])a, (byte[])b));
        a = new byte[]{40, 50, 60};
        b = null;
        ObjectHelperTest.assertFalse((boolean)ObjectHelper.equalByteArray((byte[])a, (byte[])b));
        a = null;
        b = new byte[]{40, 50, 60};
        ObjectHelperTest.assertFalse((boolean)ObjectHelper.equalByteArray((byte[])a, (byte[])b));
        a = null;
        b = null;
        ObjectHelperTest.assertTrue((boolean)ObjectHelper.equalByteArray((byte[])a, (byte[])b));
    }

    public void testCreateIterator() {
        ArrayList list = new ArrayList();
        Iterator iterator = list.iterator();
        ObjectHelperTest.assertSame((String)"Should return the same iterator", iterator, (Object)ObjectHelper.createIterator(iterator));
    }

    public void testCreateIteratorAllowEmpty() {
        String s = "a,b,,c";
        Iterator it = ObjectHelper.createIterator((Object)s, (String)",", (boolean)true);
        ObjectHelperTest.assertEquals((Object)"a", it.next());
        ObjectHelperTest.assertEquals((Object)"b", it.next());
        ObjectHelperTest.assertEquals((Object)"", it.next());
        ObjectHelperTest.assertEquals((Object)"c", it.next());
    }

    public void testCreateIteratorWithStringAndCommaSeparator() {
        String s = "a,b,c";
        Iterator it = ObjectHelper.createIterator((Object)s, (String)",");
        ObjectHelperTest.assertEquals((Object)"a", it.next());
        ObjectHelperTest.assertEquals((Object)"b", it.next());
        ObjectHelperTest.assertEquals((Object)"c", it.next());
    }

    public void testCreateIteratorWithStringAndCommaSeparatorEmptyString() {
        String s = "";
        Iterator it = ObjectHelper.createIterator((Object)s, (String)",", (boolean)true);
        ObjectHelperTest.assertEquals((Object)"", it.next());
        ObjectHelperTest.assertFalse((boolean)it.hasNext());
        try {
            it.next();
            ObjectHelperTest.fail((String)"Should have thrown exception");
        }
        catch (NoSuchElementException nsee) {
            ObjectHelperTest.assertEquals((String)"no more element available for '' at the index 1", (String)nsee.getMessage());
        }
    }

    public void testCreateIteratorWithStringAndSemiColonSeparator() {
        String s = "a;b;c";
        Iterator it = ObjectHelper.createIterator((Object)s, (String)";");
        ObjectHelperTest.assertEquals((Object)"a", it.next());
        ObjectHelperTest.assertEquals((Object)"b", it.next());
        ObjectHelperTest.assertEquals((Object)"c", it.next());
    }

    public void testCreateIteratorWithStringAndCommaInParanthesesSeparator() {
        String s = "bean:foo?method=bar('A','B','C')";
        Iterator it = ObjectHelper.createIterator((Object)s, (String)",");
        ObjectHelperTest.assertEquals((Object)"bean:foo?method=bar('A','B','C')", it.next());
    }

    public void testCreateIteratorWithStringAndCommaInParanthesesSeparatorTwo() {
        String s = "bean:foo?method=bar('A','B','C'),bean:bar?method=cool('A','Hello,World')";
        Iterator it = ObjectHelper.createIterator((Object)s, (String)",");
        ObjectHelperTest.assertEquals((Object)"bean:foo?method=bar('A','B','C')", it.next());
        ObjectHelperTest.assertEquals((Object)"bean:bar?method=cool('A','Hello,World')", it.next());
    }

    public void testCreateIteratorWithPrimitiveArrayTypes() {
        Iterator it = ObjectHelper.createIterator((Object)new byte[]{13, 127, 7, -128}, null);
        ObjectHelperTest.assertTrue((boolean)it.hasNext());
        ObjectHelperTest.assertEquals((Object)13, it.next());
        ObjectHelperTest.assertTrue((boolean)it.hasNext());
        ObjectHelperTest.assertEquals((Object)127, it.next());
        ObjectHelperTest.assertTrue((boolean)it.hasNext());
        ObjectHelperTest.assertEquals((Object)7, it.next());
        ObjectHelperTest.assertTrue((boolean)it.hasNext());
        ObjectHelperTest.assertEquals((Object)-128, it.next());
        ObjectHelperTest.assertFalse((boolean)it.hasNext());
        try {
            it.next();
            ObjectHelperTest.fail((String)"Should have thrown exception");
        }
        catch (NoSuchElementException nsee) {
            ObjectHelperTest.assertTrue((String)nsee.getMessage(), (boolean)nsee.getMessage().startsWith("no more element available for '[B@"));
            ObjectHelperTest.assertTrue((String)nsee.getMessage(), (boolean)nsee.getMessage().endsWith("at the index 4"));
        }
        it = ObjectHelper.createIterator((Object)new byte[0], null);
        ObjectHelperTest.assertFalse((boolean)it.hasNext());
        try {
            it.next();
            ObjectHelperTest.fail((String)"Should have thrown exception");
        }
        catch (NoSuchElementException nsee) {
            ObjectHelperTest.assertTrue((String)nsee.getMessage(), (boolean)nsee.getMessage().startsWith("no more element available for '[B@"));
            ObjectHelperTest.assertTrue((String)nsee.getMessage(), (boolean)nsee.getMessage().endsWith("at the index 0"));
        }
        it = ObjectHelper.createIterator((Object)new short[]{13, Short.MAX_VALUE, 7, Short.MIN_VALUE}, null);
        ObjectHelperTest.assertTrue((boolean)it.hasNext());
        ObjectHelperTest.assertEquals((Object)13, it.next());
        ObjectHelperTest.assertTrue((boolean)it.hasNext());
        ObjectHelperTest.assertEquals((Object)Short.MAX_VALUE, it.next());
        ObjectHelperTest.assertTrue((boolean)it.hasNext());
        ObjectHelperTest.assertEquals((Object)7, it.next());
        ObjectHelperTest.assertTrue((boolean)it.hasNext());
        ObjectHelperTest.assertEquals((Object)Short.MIN_VALUE, it.next());
        ObjectHelperTest.assertFalse((boolean)it.hasNext());
        try {
            it.next();
            ObjectHelperTest.fail((String)"Should have thrown exception");
        }
        catch (NoSuchElementException nsee) {
            ObjectHelperTest.assertTrue((String)nsee.getMessage(), (boolean)nsee.getMessage().startsWith("no more element available for '[S@"));
            ObjectHelperTest.assertTrue((String)nsee.getMessage(), (boolean)nsee.getMessage().endsWith("at the index 4"));
        }
        it = ObjectHelper.createIterator((Object)new short[0], null);
        ObjectHelperTest.assertFalse((boolean)it.hasNext());
        try {
            it.next();
            ObjectHelperTest.fail((String)"Should have thrown exception");
        }
        catch (NoSuchElementException nsee) {
            ObjectHelperTest.assertTrue((String)nsee.getMessage(), (boolean)nsee.getMessage().startsWith("no more element available for '[S@"));
            ObjectHelperTest.assertTrue((String)nsee.getMessage(), (boolean)nsee.getMessage().endsWith("at the index 0"));
        }
        it = ObjectHelper.createIterator((Object)new int[]{13, Integer.MAX_VALUE, 7, Integer.MIN_VALUE}, null);
        ObjectHelperTest.assertTrue((boolean)it.hasNext());
        ObjectHelperTest.assertEquals((Object)13, it.next());
        ObjectHelperTest.assertTrue((boolean)it.hasNext());
        ObjectHelperTest.assertEquals((Object)Integer.MAX_VALUE, it.next());
        ObjectHelperTest.assertTrue((boolean)it.hasNext());
        ObjectHelperTest.assertEquals((Object)7, it.next());
        ObjectHelperTest.assertTrue((boolean)it.hasNext());
        ObjectHelperTest.assertEquals((Object)Integer.MIN_VALUE, it.next());
        ObjectHelperTest.assertFalse((boolean)it.hasNext());
        try {
            it.next();
            ObjectHelperTest.fail((String)"Should have thrown exception");
        }
        catch (NoSuchElementException nsee) {
            ObjectHelperTest.assertTrue((String)nsee.getMessage(), (boolean)nsee.getMessage().startsWith("no more element available for '[I@"));
            ObjectHelperTest.assertTrue((String)nsee.getMessage(), (boolean)nsee.getMessage().endsWith("at the index 4"));
        }
        it = ObjectHelper.createIterator((Object)new int[0], null);
        ObjectHelperTest.assertFalse((boolean)it.hasNext());
        try {
            it.next();
            ObjectHelperTest.fail((String)"Should have thrown exception");
        }
        catch (NoSuchElementException nsee) {
            ObjectHelperTest.assertTrue((String)nsee.getMessage(), (boolean)nsee.getMessage().startsWith("no more element available for '[I@"));
            ObjectHelperTest.assertTrue((String)nsee.getMessage(), (boolean)nsee.getMessage().endsWith("at the index 0"));
        }
        it = ObjectHelper.createIterator((Object)new long[]{13L, Long.MAX_VALUE, 7L, Long.MIN_VALUE}, null);
        ObjectHelperTest.assertTrue((boolean)it.hasNext());
        ObjectHelperTest.assertEquals((Object)13L, it.next());
        ObjectHelperTest.assertTrue((boolean)it.hasNext());
        ObjectHelperTest.assertEquals((Object)Long.MAX_VALUE, it.next());
        ObjectHelperTest.assertTrue((boolean)it.hasNext());
        ObjectHelperTest.assertEquals((Object)7L, it.next());
        ObjectHelperTest.assertTrue((boolean)it.hasNext());
        ObjectHelperTest.assertEquals((Object)Long.MIN_VALUE, it.next());
        ObjectHelperTest.assertFalse((boolean)it.hasNext());
        try {
            it.next();
            ObjectHelperTest.fail((String)"Should have thrown exception");
        }
        catch (NoSuchElementException nsee) {
            ObjectHelperTest.assertTrue((String)nsee.getMessage(), (boolean)nsee.getMessage().startsWith("no more element available for '[J@"));
            ObjectHelperTest.assertTrue((String)nsee.getMessage(), (boolean)nsee.getMessage().endsWith("at the index 4"));
        }
        it = ObjectHelper.createIterator((Object)new long[0], null);
        ObjectHelperTest.assertFalse((boolean)it.hasNext());
        try {
            it.next();
            ObjectHelperTest.fail((String)"Should have thrown exception");
        }
        catch (NoSuchElementException nsee) {
            ObjectHelperTest.assertTrue((String)nsee.getMessage(), (boolean)nsee.getMessage().startsWith("no more element available for '[J@"));
            ObjectHelperTest.assertTrue((String)nsee.getMessage(), (boolean)nsee.getMessage().endsWith("at the index 0"));
        }
        it = ObjectHelper.createIterator((Object)new float[]{13.7f, Float.MAX_VALUE, 7.13f, Float.MIN_VALUE}, null);
        ObjectHelperTest.assertTrue((boolean)it.hasNext());
        ObjectHelperTest.assertEquals((Object)Float.valueOf(13.7f), it.next());
        ObjectHelperTest.assertTrue((boolean)it.hasNext());
        ObjectHelperTest.assertEquals((Object)Float.valueOf(Float.MAX_VALUE), it.next());
        ObjectHelperTest.assertTrue((boolean)it.hasNext());
        ObjectHelperTest.assertEquals((Object)Float.valueOf(7.13f), it.next());
        ObjectHelperTest.assertTrue((boolean)it.hasNext());
        ObjectHelperTest.assertEquals((Object)Float.valueOf(Float.MIN_VALUE), it.next());
        ObjectHelperTest.assertFalse((boolean)it.hasNext());
        try {
            it.next();
            ObjectHelperTest.fail((String)"Should have thrown exception");
        }
        catch (NoSuchElementException nsee) {
            ObjectHelperTest.assertTrue((String)nsee.getMessage(), (boolean)nsee.getMessage().startsWith("no more element available for '[F@"));
            ObjectHelperTest.assertTrue((String)nsee.getMessage(), (boolean)nsee.getMessage().endsWith("at the index 4"));
        }
        it = ObjectHelper.createIterator((Object)new float[0], null);
        ObjectHelperTest.assertFalse((boolean)it.hasNext());
        try {
            it.next();
            ObjectHelperTest.fail((String)"Should have thrown exception");
        }
        catch (NoSuchElementException nsee) {
            ObjectHelperTest.assertTrue((String)nsee.getMessage(), (boolean)nsee.getMessage().startsWith("no more element available for '[F@"));
            ObjectHelperTest.assertTrue((String)nsee.getMessage(), (boolean)nsee.getMessage().endsWith("at the index 0"));
        }
        it = ObjectHelper.createIterator((Object)new double[]{13.7, Double.MAX_VALUE, 7.13, Double.MIN_VALUE}, null);
        ObjectHelperTest.assertTrue((boolean)it.hasNext());
        ObjectHelperTest.assertEquals((Object)13.7, it.next());
        ObjectHelperTest.assertTrue((boolean)it.hasNext());
        ObjectHelperTest.assertEquals((Object)Double.MAX_VALUE, it.next());
        ObjectHelperTest.assertTrue((boolean)it.hasNext());
        ObjectHelperTest.assertEquals((Object)7.13, it.next());
        ObjectHelperTest.assertTrue((boolean)it.hasNext());
        ObjectHelperTest.assertEquals((Object)Double.MIN_VALUE, it.next());
        ObjectHelperTest.assertFalse((boolean)it.hasNext());
        try {
            it.next();
            ObjectHelperTest.fail((String)"Should have thrown exception");
        }
        catch (NoSuchElementException nsee) {
            ObjectHelperTest.assertTrue((String)nsee.getMessage(), (boolean)nsee.getMessage().startsWith("no more element available for '[D@"));
            ObjectHelperTest.assertTrue((String)nsee.getMessage(), (boolean)nsee.getMessage().endsWith("at the index 4"));
        }
        it = ObjectHelper.createIterator((Object)new double[0], null);
        ObjectHelperTest.assertFalse((boolean)it.hasNext());
        try {
            it.next();
            ObjectHelperTest.fail((String)"Should have thrown exception");
        }
        catch (NoSuchElementException nsee) {
            ObjectHelperTest.assertTrue((String)nsee.getMessage(), (boolean)nsee.getMessage().startsWith("no more element available for '[D@"));
            ObjectHelperTest.assertTrue((String)nsee.getMessage(), (boolean)nsee.getMessage().endsWith("at the index 0"));
        }
        it = ObjectHelper.createIterator((Object)new char[]{'C', 'a', 'm', 'e', 'l'}, null);
        ObjectHelperTest.assertTrue((boolean)it.hasNext());
        ObjectHelperTest.assertEquals((Object)Character.valueOf('C'), it.next());
        ObjectHelperTest.assertTrue((boolean)it.hasNext());
        ObjectHelperTest.assertEquals((Object)Character.valueOf('a'), it.next());
        ObjectHelperTest.assertTrue((boolean)it.hasNext());
        ObjectHelperTest.assertEquals((Object)Character.valueOf('m'), it.next());
        ObjectHelperTest.assertTrue((boolean)it.hasNext());
        ObjectHelperTest.assertEquals((Object)Character.valueOf('e'), it.next());
        ObjectHelperTest.assertTrue((boolean)it.hasNext());
        ObjectHelperTest.assertEquals((Object)Character.valueOf('l'), it.next());
        ObjectHelperTest.assertFalse((boolean)it.hasNext());
        try {
            it.next();
            ObjectHelperTest.fail((String)"Should have thrown exception");
        }
        catch (NoSuchElementException nsee) {
            ObjectHelperTest.assertTrue((String)nsee.getMessage(), (boolean)nsee.getMessage().startsWith("no more element available for '[C@"));
            ObjectHelperTest.assertTrue((String)nsee.getMessage(), (boolean)nsee.getMessage().endsWith("at the index 5"));
        }
        it = ObjectHelper.createIterator((Object)new char[0], null);
        ObjectHelperTest.assertFalse((boolean)it.hasNext());
        try {
            it.next();
            ObjectHelperTest.fail((String)"Should have thrown exception");
        }
        catch (NoSuchElementException nsee) {
            ObjectHelperTest.assertTrue((String)nsee.getMessage(), (boolean)nsee.getMessage().startsWith("no more element available for '[C@"));
            ObjectHelperTest.assertTrue((String)nsee.getMessage(), (boolean)nsee.getMessage().endsWith("at the index 0"));
        }
        it = ObjectHelper.createIterator((Object)new boolean[]{false, true, false, true, true}, null);
        ObjectHelperTest.assertTrue((boolean)it.hasNext());
        ObjectHelperTest.assertEquals((Object)Boolean.FALSE, it.next());
        ObjectHelperTest.assertTrue((boolean)it.hasNext());
        ObjectHelperTest.assertEquals((Object)Boolean.TRUE, it.next());
        ObjectHelperTest.assertTrue((boolean)it.hasNext());
        ObjectHelperTest.assertEquals((Object)Boolean.FALSE, it.next());
        ObjectHelperTest.assertTrue((boolean)it.hasNext());
        ObjectHelperTest.assertEquals((Object)Boolean.TRUE, it.next());
        ObjectHelperTest.assertTrue((boolean)it.hasNext());
        ObjectHelperTest.assertEquals((Object)Boolean.TRUE, it.next());
        ObjectHelperTest.assertFalse((boolean)it.hasNext());
        try {
            it.next();
            ObjectHelperTest.fail((String)"Should have thrown exception");
        }
        catch (NoSuchElementException nsee) {
            ObjectHelperTest.assertTrue((String)nsee.getMessage(), (boolean)nsee.getMessage().startsWith("no more element available for '[Z@"));
            ObjectHelperTest.assertTrue((String)nsee.getMessage(), (boolean)nsee.getMessage().endsWith("at the index 5"));
        }
        it = ObjectHelper.createIterator((Object)new boolean[0], null);
        ObjectHelperTest.assertFalse((boolean)it.hasNext());
        try {
            it.next();
            ObjectHelperTest.fail((String)"Should have thrown exception");
        }
        catch (NoSuchElementException nsee) {
            ObjectHelperTest.assertTrue((String)nsee.getMessage(), (boolean)nsee.getMessage().startsWith("no more element available for '[Z@"));
            ObjectHelperTest.assertTrue((String)nsee.getMessage(), (boolean)nsee.getMessage().endsWith("at the index 0"));
        }
    }

    public void testArrayAsIterator() throws Exception {
        String[] data = new String[]{"a", "b"};
        Iterator iter = ObjectHelper.createIterator((Object)data);
        ObjectHelperTest.assertTrue((String)"should have next", (boolean)iter.hasNext());
        Object a = iter.next();
        ObjectHelperTest.assertEquals((String)"a", (Object)"a", a);
        ObjectHelperTest.assertTrue((String)"should have next", (boolean)iter.hasNext());
        Object b = iter.next();
        ObjectHelperTest.assertEquals((String)"b", (Object)"b", b);
        ObjectHelperTest.assertFalse((String)"should not have a next", (boolean)iter.hasNext());
    }

    public void testIsEmpty() {
        ObjectHelperTest.assertTrue((boolean)ObjectHelper.isEmpty(null));
        ObjectHelperTest.assertTrue((boolean)ObjectHelper.isEmpty((Object)""));
        ObjectHelperTest.assertTrue((boolean)ObjectHelper.isEmpty((Object)" "));
        ObjectHelperTest.assertFalse((boolean)ObjectHelper.isEmpty((Object)"A"));
        ObjectHelperTest.assertFalse((boolean)ObjectHelper.isEmpty((Object)" A"));
        ObjectHelperTest.assertFalse((boolean)ObjectHelper.isEmpty((Object)" A "));
        ObjectHelperTest.assertFalse((boolean)ObjectHelper.isEmpty((Object)new Object()));
    }

    public void testIsNotEmpty() {
        ObjectHelperTest.assertFalse((boolean)ObjectHelper.isNotEmpty(null));
        ObjectHelperTest.assertFalse((boolean)ObjectHelper.isNotEmpty((Object)""));
        ObjectHelperTest.assertFalse((boolean)ObjectHelper.isNotEmpty((Object)" "));
        ObjectHelperTest.assertTrue((boolean)ObjectHelper.isNotEmpty((Object)"A"));
        ObjectHelperTest.assertTrue((boolean)ObjectHelper.isNotEmpty((Object)" A"));
        ObjectHelperTest.assertTrue((boolean)ObjectHelper.isNotEmpty((Object)" A "));
        ObjectHelperTest.assertTrue((boolean)ObjectHelper.isNotEmpty((Object)new Object()));
    }

    public void testIteratorWithComma() {
        Iterator it = ObjectHelper.createIterator((Object)"Claus,Jonathan");
        ObjectHelperTest.assertEquals((Object)"Claus", it.next());
        ObjectHelperTest.assertEquals((Object)"Jonathan", it.next());
        ObjectHelperTest.assertEquals((boolean)false, (boolean)it.hasNext());
    }

    public void testIteratorWithOtherDelimiter() {
        Iterator it = ObjectHelper.createIterator((Object)"Claus#Jonathan", (String)"#");
        ObjectHelperTest.assertEquals((Object)"Claus", it.next());
        ObjectHelperTest.assertEquals((Object)"Jonathan", it.next());
        ObjectHelperTest.assertEquals((boolean)false, (boolean)it.hasNext());
    }

    public void testIteratorEmpty() {
        Iterator it = ObjectHelper.createIterator((Object)"");
        ObjectHelperTest.assertEquals((boolean)false, (boolean)it.hasNext());
        try {
            it.next();
            ObjectHelperTest.fail((String)"Should have thrown exception");
        }
        catch (NoSuchElementException nsee) {
            ObjectHelperTest.assertEquals((String)"no more element available for '' at the index 0", (String)nsee.getMessage());
        }
        it = ObjectHelper.createIterator((Object)"    ");
        ObjectHelperTest.assertEquals((boolean)false, (boolean)it.hasNext());
        try {
            it.next();
            ObjectHelperTest.fail((String)"Should have thrown exception");
        }
        catch (NoSuchElementException nsee) {
            ObjectHelperTest.assertEquals((String)"no more element available for '    ' at the index 0", (String)nsee.getMessage());
        }
        it = ObjectHelper.createIterator(null);
        ObjectHelperTest.assertEquals((boolean)false, (boolean)it.hasNext());
        try {
            it.next();
            ObjectHelperTest.fail((String)"Should have thrown exception");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testIteratorIdempotentNext() {
        Iterator it = ObjectHelper.createIterator((Object)"a");
        ObjectHelperTest.assertTrue((boolean)it.hasNext());
        ObjectHelperTest.assertTrue((boolean)it.hasNext());
        it.next();
        ObjectHelperTest.assertFalse((boolean)it.hasNext());
        try {
            it.next();
            ObjectHelperTest.fail((String)"Should have thrown exception");
        }
        catch (NoSuchElementException nsee) {
            ObjectHelperTest.assertEquals((String)"no more element available for 'a' at the index 1", (String)nsee.getMessage());
        }
    }

    public void testIteratorIdempotentNextWithNodeList() {
        NodeList nodeList = new NodeList(){

            @Override
            public Node item(int index) {
                return null;
            }

            @Override
            public int getLength() {
                return 1;
            }
        };
        Iterator it = ObjectHelper.createIterator((Object)nodeList);
        ObjectHelperTest.assertTrue((boolean)it.hasNext());
        ObjectHelperTest.assertTrue((boolean)it.hasNext());
        it.next();
        ObjectHelperTest.assertFalse((boolean)it.hasNext());
        try {
            it.next();
            ObjectHelperTest.fail((String)"Should have thrown exception");
        }
        catch (NoSuchElementException nsee) {
            ObjectHelperTest.assertTrue((String)nsee.getMessage(), (boolean)nsee.getMessage().startsWith("no more element available for 'org.apache.camel.util.ObjectHelperTest$"));
            ObjectHelperTest.assertTrue((String)nsee.getMessage(), (boolean)nsee.getMessage().endsWith("at the index 1"));
        }
    }

    public void testGetCamelContextPropertiesWithPrefix() {
        DefaultCamelContext context = new DefaultCamelContext();
        Map properties = context.getProperties();
        properties.put("camel.object.helper.test1", "test1");
        properties.put("camel.object.helper.test2", "test2");
        properties.put("camel.object.test", "test");
        Properties result = ObjectHelper.getCamelPropertiesWithPrefix((String)"camel.object.helper.", (CamelContext)context);
        ObjectHelperTest.assertEquals((String)"Get a wrong size properties", (int)2, (int)result.size());
        ObjectHelperTest.assertEquals((String)"It should contain the test1", (Object)"test1", (Object)result.get("test1"));
        ObjectHelperTest.assertEquals((String)"It should contain the test2", (Object)"test2", (Object)result.get("test2"));
    }

    public void testEvaluateAsPredicate() throws Exception {
        ObjectHelperTest.assertEquals((boolean)false, (boolean)ObjectHelper.evaluateValuePredicate(null));
        ObjectHelperTest.assertEquals((boolean)true, (boolean)ObjectHelper.evaluateValuePredicate((Object)123));
        ObjectHelperTest.assertEquals((boolean)true, (boolean)ObjectHelper.evaluateValuePredicate((Object)"true"));
        ObjectHelperTest.assertEquals((boolean)true, (boolean)ObjectHelper.evaluateValuePredicate((Object)"TRUE"));
        ObjectHelperTest.assertEquals((boolean)false, (boolean)ObjectHelper.evaluateValuePredicate((Object)"false"));
        ObjectHelperTest.assertEquals((boolean)false, (boolean)ObjectHelper.evaluateValuePredicate((Object)"FALSE"));
        ObjectHelperTest.assertEquals((boolean)true, (boolean)ObjectHelper.evaluateValuePredicate((Object)"foobar"));
        ObjectHelperTest.assertEquals((boolean)true, (boolean)ObjectHelper.evaluateValuePredicate((Object)""));
        ObjectHelperTest.assertEquals((boolean)true, (boolean)ObjectHelper.evaluateValuePredicate((Object)" "));
        ArrayList<String> list = new ArrayList<String>();
        ObjectHelperTest.assertEquals((boolean)false, (boolean)ObjectHelper.evaluateValuePredicate(list));
        list.add("foo");
        ObjectHelperTest.assertEquals((boolean)true, (boolean)ObjectHelper.evaluateValuePredicate(list));
    }

    public void testIsPrimitiveArrayType() {
        ObjectHelperTest.assertTrue((boolean)ObjectHelper.isPrimitiveArrayType(byte[].class));
        ObjectHelperTest.assertTrue((boolean)ObjectHelper.isPrimitiveArrayType(short[].class));
        ObjectHelperTest.assertTrue((boolean)ObjectHelper.isPrimitiveArrayType(int[].class));
        ObjectHelperTest.assertTrue((boolean)ObjectHelper.isPrimitiveArrayType(long[].class));
        ObjectHelperTest.assertTrue((boolean)ObjectHelper.isPrimitiveArrayType(float[].class));
        ObjectHelperTest.assertTrue((boolean)ObjectHelper.isPrimitiveArrayType(double[].class));
        ObjectHelperTest.assertTrue((boolean)ObjectHelper.isPrimitiveArrayType(char[].class));
        ObjectHelperTest.assertTrue((boolean)ObjectHelper.isPrimitiveArrayType(boolean[].class));
        ObjectHelperTest.assertFalse((boolean)ObjectHelper.isPrimitiveArrayType(Object[].class));
        ObjectHelperTest.assertFalse((boolean)ObjectHelper.isPrimitiveArrayType(Byte[].class));
        ObjectHelperTest.assertFalse((boolean)ObjectHelper.isPrimitiveArrayType(Short[].class));
        ObjectHelperTest.assertFalse((boolean)ObjectHelper.isPrimitiveArrayType(Integer[].class));
        ObjectHelperTest.assertFalse((boolean)ObjectHelper.isPrimitiveArrayType(Long[].class));
        ObjectHelperTest.assertFalse((boolean)ObjectHelper.isPrimitiveArrayType(Float[].class));
        ObjectHelperTest.assertFalse((boolean)ObjectHelper.isPrimitiveArrayType(Double[].class));
        ObjectHelperTest.assertFalse((boolean)ObjectHelper.isPrimitiveArrayType(Character[].class));
        ObjectHelperTest.assertFalse((boolean)ObjectHelper.isPrimitiveArrayType(Boolean[].class));
        ObjectHelperTest.assertFalse((boolean)ObjectHelper.isPrimitiveArrayType(Void[].class));
        ObjectHelperTest.assertFalse((boolean)ObjectHelper.isPrimitiveArrayType(CamelContext[].class));
        ObjectHelperTest.assertFalse((boolean)ObjectHelper.isPrimitiveArrayType(null));
    }

    public void testBefore() {
        ObjectHelperTest.assertEquals((String)"Hello ", (String)ObjectHelper.before((String)"Hello World", (String)"World"));
        ObjectHelperTest.assertEquals((String)"Hello ", (String)ObjectHelper.before((String)"Hello World Again", (String)"World"));
        ObjectHelperTest.assertEquals(null, (String)ObjectHelper.before((String)"Hello Again", (String)"Foo"));
    }

    public void testAfter() {
        ObjectHelperTest.assertEquals((String)" World", (String)ObjectHelper.after((String)"Hello World", (String)"Hello"));
        ObjectHelperTest.assertEquals((String)" World Again", (String)ObjectHelper.after((String)"Hello World Again", (String)"Hello"));
        ObjectHelperTest.assertEquals(null, (String)ObjectHelper.after((String)"Hello Again", (String)"Foo"));
    }

    public void testBetween() {
        ObjectHelperTest.assertEquals((String)"foo bar", (String)ObjectHelper.between((String)"Hello 'foo bar' how are you", (String)"'", (String)"'"));
        ObjectHelperTest.assertEquals((String)"foo bar", (String)ObjectHelper.between((String)"Hello ${foo bar} how are you", (String)"${", (String)"}"));
        ObjectHelperTest.assertEquals(null, (String)ObjectHelper.between((String)"Hello ${foo bar} how are you", (String)"'", (String)"'"));
    }

    public void testBetweenOuterPair() {
        ObjectHelperTest.assertEquals((String)"bar(baz)123", (String)ObjectHelper.betweenOuterPair((String)"foo(bar(baz)123)", (char)'(', (char)')'));
        ObjectHelperTest.assertEquals(null, (String)ObjectHelper.betweenOuterPair((String)"foo(bar(baz)123))", (char)'(', (char)')'));
        ObjectHelperTest.assertEquals(null, (String)ObjectHelper.betweenOuterPair((String)"foo(bar(baz123", (char)'(', (char)')'));
        ObjectHelperTest.assertEquals(null, (String)ObjectHelper.betweenOuterPair((String)"foo)bar)baz123", (char)'(', (char)')'));
        ObjectHelperTest.assertEquals((String)"bar", (String)ObjectHelper.betweenOuterPair((String)"foo(bar)baz123", (char)'(', (char)')'));
        ObjectHelperTest.assertEquals((String)"'bar', 'baz()123', 123", (String)ObjectHelper.betweenOuterPair((String)"foo('bar', 'baz()123', 123)", (char)'(', (char)')'));
    }

    public void testIsJavaIdentifier() {
        ObjectHelperTest.assertEquals((boolean)true, (boolean)ObjectHelper.isJavaIdentifier((String)"foo"));
        ObjectHelperTest.assertEquals((boolean)false, (boolean)ObjectHelper.isJavaIdentifier((String)"foo.bar"));
        ObjectHelperTest.assertEquals((boolean)false, (boolean)ObjectHelper.isJavaIdentifier((String)""));
        ObjectHelperTest.assertEquals((boolean)false, (boolean)ObjectHelper.isJavaIdentifier(null));
    }

    public void testGetDefaultCharSet() {
        ObjectHelperTest.assertNotNull((Object)ObjectHelper.getDefaultCharacterSet());
    }

    public void testConvertPrimitiveTypeToWrapper() {
        ObjectHelperTest.assertEquals((String)"java.lang.Integer", (String)ObjectHelper.convertPrimitiveTypeToWrapperType(Integer.TYPE).getName());
        ObjectHelperTest.assertEquals((String)"java.lang.Long", (String)ObjectHelper.convertPrimitiveTypeToWrapperType(Long.TYPE).getName());
        ObjectHelperTest.assertEquals((String)"java.lang.Double", (String)ObjectHelper.convertPrimitiveTypeToWrapperType(Double.TYPE).getName());
        ObjectHelperTest.assertEquals((String)"java.lang.Float", (String)ObjectHelper.convertPrimitiveTypeToWrapperType(Float.TYPE).getName());
        ObjectHelperTest.assertEquals((String)"java.lang.Short", (String)ObjectHelper.convertPrimitiveTypeToWrapperType(Short.TYPE).getName());
        ObjectHelperTest.assertEquals((String)"java.lang.Byte", (String)ObjectHelper.convertPrimitiveTypeToWrapperType(Byte.TYPE).getName());
        ObjectHelperTest.assertEquals((String)"java.lang.Boolean", (String)ObjectHelper.convertPrimitiveTypeToWrapperType(Boolean.TYPE).getName());
        ObjectHelperTest.assertEquals((String)"java.lang.Character", (String)ObjectHelper.convertPrimitiveTypeToWrapperType(Character.TYPE).getName());
        ObjectHelperTest.assertEquals((String)"java.lang.Object", (String)ObjectHelper.convertPrimitiveTypeToWrapperType(Object.class).getName());
    }

    public void testAsString() {
        Object[] args = new String[]{"foo", "bar"};
        String out = ObjectHelper.asString((Object[])args);
        ObjectHelperTest.assertNotNull((Object)out);
        ObjectHelperTest.assertEquals((String)"{foo, bar}", (String)out);
    }

    public void testName() {
        ObjectHelperTest.assertEquals((String)"java.lang.Integer", (String)ObjectHelper.name(Integer.class));
        ObjectHelperTest.assertEquals(null, (String)ObjectHelper.name(null));
    }

    public void testClassName() {
        ObjectHelperTest.assertEquals((String)"java.lang.Integer", (String)ObjectHelper.className((Object)Integer.valueOf("5")));
        ObjectHelperTest.assertEquals(null, (String)ObjectHelper.className(null));
    }

    public void testGetSystemPropertyDefault() {
        ObjectHelperTest.assertEquals((String)"foo", (String)ObjectHelper.getSystemProperty((String)"CamelFooDoesNotExist", (String)"foo"));
    }

    public void testGetSystemPropertyBooleanDefault() {
        ObjectHelperTest.assertEquals((boolean)true, (boolean)ObjectHelper.getSystemProperty((String)"CamelFooDoesNotExist", (Boolean)Boolean.TRUE));
    }

    public void testMatches() {
        ArrayList<Object> data = new ArrayList<Object>();
        data.add("foo");
        data.add("bar");
        ObjectHelperTest.assertEquals((boolean)true, (boolean)ObjectHelper.matches(data));
        data.clear();
        data.add(Boolean.FALSE);
        data.add("bar");
        ObjectHelperTest.assertEquals((boolean)false, (boolean)ObjectHelper.matches(data));
        data.clear();
        ObjectHelperTest.assertEquals((boolean)false, (boolean)ObjectHelper.matches(data));
    }

    public void testToBoolean() {
        ObjectHelperTest.assertEquals((Object)Boolean.TRUE, (Object)ObjectHelper.toBoolean((Object)Boolean.TRUE));
        ObjectHelperTest.assertEquals((Object)Boolean.TRUE, (Object)ObjectHelper.toBoolean((Object)"true"));
        ObjectHelperTest.assertEquals((Object)Boolean.TRUE, (Object)ObjectHelper.toBoolean((Object)Integer.valueOf("1")));
        ObjectHelperTest.assertEquals((Object)Boolean.FALSE, (Object)ObjectHelper.toBoolean((Object)Integer.valueOf("0")));
        ObjectHelperTest.assertEquals(null, (Object)ObjectHelper.toBoolean((Object)new Date()));
    }

    public void testIteratorWithMessage() {
        DefaultMessage msg = new DefaultMessage();
        msg.setBody((Object)"a,b,c");
        Iterator it = ObjectHelper.createIterator((Object)msg);
        ObjectHelperTest.assertEquals((Object)"a", it.next());
        ObjectHelperTest.assertEquals((Object)"b", it.next());
        ObjectHelperTest.assertEquals((Object)"c", it.next());
        ObjectHelperTest.assertFalse((boolean)it.hasNext());
        try {
            it.next();
            ObjectHelperTest.fail((String)"Should have thrown exception");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testIteratorWithEmptyMessage() {
        DefaultMessage msg = new DefaultMessage();
        msg.setBody((Object)"");
        Iterator it = ObjectHelper.createIterator((Object)msg);
        ObjectHelperTest.assertFalse((boolean)it.hasNext());
        try {
            it.next();
            ObjectHelperTest.fail((String)"Should have thrown exception");
        }
        catch (NoSuchElementException nsee) {
            ObjectHelperTest.assertEquals((String)"no more element available for '' at the index 0", (String)nsee.getMessage());
        }
    }

    public void testIteratorWithNullMessage() {
        DefaultMessage msg = new DefaultMessage();
        msg.setBody(null);
        Iterator it = ObjectHelper.createIterator((Object)msg);
        ObjectHelperTest.assertFalse((boolean)it.hasNext());
        try {
            it.next();
            ObjectHelperTest.fail((String)"Should have thrown exception");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testIterable() {
        final ArrayList<String> data = new ArrayList<String>();
        data.add("A");
        data.add("B");
        data.add("C");
        Iterable<String> itb = new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return data.iterator();
            }
        };
        Iterator it = ObjectHelper.createIterator((Object)itb);
        ObjectHelperTest.assertEquals((Object)"A", it.next());
        ObjectHelperTest.assertEquals((Object)"B", it.next());
        ObjectHelperTest.assertEquals((Object)"C", it.next());
        ObjectHelperTest.assertFalse((boolean)it.hasNext());
        try {
            it.next();
            ObjectHelperTest.fail((String)"Should have thrown exception");
        }
        catch (NoSuchElementException nsee) {
            // empty catch block
        }
    }

    public void testNormalizeClassName() {
        ObjectHelperTest.assertEquals((String)"Should get the right class name", (String)"my.package-info", (String)ObjectHelper.normalizeClassName((String)"my.package-info"));
        ObjectHelperTest.assertEquals((String)"Should get the right class name", (String)"Integer[]", (String)ObjectHelper.normalizeClassName((String)"Integer[] \r"));
        ObjectHelperTest.assertEquals((String)"Should get the right class name", (String)"Hello_World", (String)ObjectHelper.normalizeClassName((String)"Hello_World"));
        ObjectHelperTest.assertEquals((String)"Should get the right class name", (String)"", (String)ObjectHelper.normalizeClassName((String)"////"));
    }

    public void testLookupConstantFieldValue() {
        ObjectHelperTest.assertEquals((String)"CamelFileName", (String)ObjectHelper.lookupConstantFieldValue(Exchange.class, (String)"FILE_NAME"));
        ObjectHelperTest.assertEquals(null, (String)ObjectHelper.lookupConstantFieldValue(Exchange.class, (String)"XXX"));
        ObjectHelperTest.assertEquals(null, (String)ObjectHelper.lookupConstantFieldValue(null, (String)"FILE_NAME"));
    }

    public void testHasDefaultPublicNoArgConstructor() {
        ObjectHelperTest.assertTrue((boolean)ObjectHelper.hasDefaultPublicNoArgConstructor(ObjectHelperTest.class));
        ObjectHelperTest.assertFalse((boolean)ObjectHelper.hasDefaultPublicNoArgConstructor(MyStaticClass.class));
    }

    public void testIdentityHashCode() {
        MyDummyObject dummy = new MyDummyObject("Camel");
        String code = ObjectHelper.getIdentityHashCode((Object)dummy);
        String code2 = ObjectHelper.getIdentityHashCode((Object)dummy);
        ObjectHelperTest.assertEquals((String)code, (String)code2);
        MyDummyObject dummyB = new MyDummyObject("Camel");
        String code3 = ObjectHelper.getIdentityHashCode((Object)dummyB);
        ObjectHelperTest.assertNotSame((Object)code, (Object)code3);
    }

    public void testIsNaN() throws Exception {
        ObjectHelperTest.assertTrue((boolean)ObjectHelper.isNaN((Object)Float.valueOf(Float.NaN)));
        ObjectHelperTest.assertTrue((boolean)ObjectHelper.isNaN((Object)Double.NaN));
        ObjectHelperTest.assertFalse((boolean)ObjectHelper.isNaN(null));
        ObjectHelperTest.assertFalse((boolean)ObjectHelper.isNaN((Object)""));
        ObjectHelperTest.assertFalse((boolean)ObjectHelper.isNaN((Object)"1.0"));
        ObjectHelperTest.assertFalse((boolean)ObjectHelper.isNaN((Object)1));
        ObjectHelperTest.assertFalse((boolean)ObjectHelper.isNaN((Object)Float.valueOf(1.5f)));
        ObjectHelperTest.assertFalse((boolean)ObjectHelper.isNaN((Object)1.5));
        ObjectHelperTest.assertFalse((boolean)ObjectHelper.isNaN((Object)false));
        ObjectHelperTest.assertFalse((boolean)ObjectHelper.isNaN((Object)true));
    }

    public void testNotNull() {
        Long expected = 3L;
        Long actual = (Long)ObjectHelper.notNull((Object)expected, (String)"expected");
        ObjectHelperTest.assertSame((String)"Didn't get the same object back!", (Object)expected, (Object)actual);
        Long actual2 = (Long)ObjectHelper.notNull((Object)expected, (String)"expected", (Object)"holder");
        ObjectHelperTest.assertSame((String)"Didn't get the same object back!", (Object)expected, (Object)actual2);
        Object expected2 = null;
        try {
            ObjectHelper.notNull(expected2, (String)"expected2");
            ObjectHelperTest.fail((String)"Should have thrown exception");
        }
        catch (IllegalArgumentException iae) {
            ObjectHelperTest.assertEquals((String)"expected2 must be specified", (String)iae.getMessage());
        }
        try {
            ObjectHelper.notNull(expected2, (String)"expected2", (Object)"holder");
            ObjectHelperTest.fail((String)"Should have thrown exception");
        }
        catch (IllegalArgumentException iae) {
            ObjectHelperTest.assertEquals((String)"expected2 must be specified on: holder", (String)iae.getMessage());
        }
    }
}

