/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.binding;

import java.util.Locale;
import java.util.Map;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Route;
import org.apache.camel.processor.MarshalProcessor;
import org.apache.camel.processor.UnmarshalProcessor;
import org.apache.camel.processor.binding.BindingException;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.support.SynchronizationAdapter;
import org.apache.camel.util.AsyncProcessorHelper;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.MessageHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;

public class RestBindingProcessor
extends ServiceSupport
implements AsyncProcessor {
    private final CamelContext camelContext;
    private final AsyncProcessor jsonUnmarshal;
    private final AsyncProcessor xmlUnmarshal;
    private final AsyncProcessor jsonMarshal;
    private final AsyncProcessor xmlMarshal;
    private final String consumes;
    private final String produces;
    private final String bindingMode;
    private final boolean skipBindingOnErrorCode;
    private final boolean enableCORS;
    private final Map<String, String> corsHeaders;
    private final Map<String, String> queryDefaultValues;

    public RestBindingProcessor(CamelContext camelContext, DataFormat jsonDataFormat, DataFormat xmlDataFormat, DataFormat outJsonDataFormat, DataFormat outXmlDataFormat, String consumes, String produces, String bindingMode, boolean skipBindingOnErrorCode, boolean enableCORS, Map<String, String> corsHeaders, Map<String, String> queryDefaultValues) {
        this.camelContext = camelContext;
        this.jsonUnmarshal = jsonDataFormat != null ? new UnmarshalProcessor(jsonDataFormat) : null;
        this.jsonMarshal = outJsonDataFormat != null ? new MarshalProcessor(outJsonDataFormat) : (jsonDataFormat != null ? new MarshalProcessor(jsonDataFormat) : null);
        this.xmlUnmarshal = xmlDataFormat != null ? new UnmarshalProcessor(xmlDataFormat) : null;
        this.xmlMarshal = outXmlDataFormat != null ? new MarshalProcessor(outXmlDataFormat) : (xmlDataFormat != null ? new MarshalProcessor(xmlDataFormat) : null);
        this.consumes = consumes;
        this.produces = produces;
        this.bindingMode = bindingMode;
        this.skipBindingOnErrorCode = skipBindingOnErrorCode;
        this.enableCORS = enableCORS;
        this.corsHeaders = corsHeaders;
        this.queryDefaultValues = queryDefaultValues;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        AsyncProcessorHelper.process(this, exchange);
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        if (this.enableCORS) {
            exchange.addOnCompletion(new RestBindingCORSOnCompletion(this.corsHeaders));
        }
        boolean isXml = false;
        boolean isJson = false;
        String contentType = ExchangeHelper.getContentType(exchange);
        if (contentType != null) {
            isXml = contentType.toLowerCase(Locale.ENGLISH).contains("xml");
            isJson = contentType.toLowerCase(Locale.ENGLISH).contains("json");
        }
        if (!isXml && !isJson) {
            isXml = this.consumes != null && this.consumes.toLowerCase(Locale.ENGLISH).contains("xml");
            isJson = this.consumes != null && this.consumes.toLowerCase(Locale.ENGLISH).contains("json");
        }
        if (!(isJson &= this.bindingMode.equals("auto") || this.bindingMode.contains("json")) && !(isXml &= this.bindingMode.equals("auto") || this.bindingMode.contains("xml"))) {
            isXml = this.bindingMode.equals("auto") || this.bindingMode.contains("xml");
            isJson = this.bindingMode.equals("auto") || this.bindingMode.contains("json");
        }
        String accept = exchange.getIn().getHeader("Accept", String.class);
        String body = null;
        if (exchange.getIn().getBody() != null && (isXml || isJson) && (body = MessageHelper.extractBodyAsString(exchange.getIn())) != null) {
            exchange.getIn().setBody(body);
            if (isXml && isJson) {
                isXml = body.startsWith("<");
                boolean bl = isJson = !isXml;
            }
        }
        if (this.queryDefaultValues != null) {
            for (Map.Entry<String, String> entry : this.queryDefaultValues.entrySet()) {
                if (exchange.getIn().getHeader(entry.getKey()) != null) continue;
                exchange.getIn().setHeader(entry.getKey(), entry.getValue());
            }
        }
        if (isJson && this.jsonUnmarshal != null) {
            exchange.addOnCompletion(new RestBindingMarshalOnCompletion(exchange.getFromRouteId(), this.jsonMarshal, this.xmlMarshal, false, accept));
            if (ObjectHelper.isNotEmpty(body)) {
                return this.jsonUnmarshal.process(exchange, callback);
            }
            callback.done(true);
            return true;
        }
        if (isXml && this.xmlUnmarshal != null) {
            exchange.addOnCompletion(new RestBindingMarshalOnCompletion(exchange.getFromRouteId(), this.jsonMarshal, this.xmlMarshal, true, accept));
            if (ObjectHelper.isNotEmpty(body)) {
                return this.xmlUnmarshal.process(exchange, callback);
            }
            callback.done(true);
            return true;
        }
        if ("off".equals(this.bindingMode) || this.bindingMode.equals("auto")) {
            exchange.addOnCompletion(new RestBindingMarshalOnCompletion(exchange.getFromRouteId(), this.jsonMarshal, this.xmlMarshal, false, accept));
            callback.done(true);
            return true;
        }
        if (this.bindingMode.contains("xml")) {
            exchange.setException(new BindingException("Cannot bind to xml as message body is not xml compatible", exchange));
        } else {
            exchange.setException(new BindingException("Cannot bind to json as message body is not json compatible", exchange));
        }
        callback.done(true);
        return true;
    }

    public String toString() {
        return "RestBindingProcessor";
    }

    @Override
    protected void doStart() throws Exception {
        if (this.jsonMarshal instanceof CamelContextAware) {
            ((CamelContextAware)((Object)this.jsonMarshal)).setCamelContext(this.camelContext);
        }
        if (this.jsonUnmarshal instanceof CamelContextAware) {
            ((CamelContextAware)((Object)this.jsonUnmarshal)).setCamelContext(this.camelContext);
        }
        if (this.xmlMarshal instanceof CamelContextAware) {
            ((CamelContextAware)((Object)this.xmlMarshal)).setCamelContext(this.camelContext);
        }
        if (this.xmlUnmarshal instanceof CamelContextAware) {
            ((CamelContextAware)((Object)this.xmlUnmarshal)).setCamelContext(this.camelContext);
        }
        ServiceHelper.startServices(this.jsonMarshal, this.jsonUnmarshal, this.xmlMarshal, this.xmlUnmarshal);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopServices(this.jsonMarshal, this.jsonUnmarshal, this.xmlMarshal, this.xmlUnmarshal);
    }

    private final class RestBindingCORSOnCompletion
    extends SynchronizationAdapter {
        private final Map<String, String> corsHeaders;

        private RestBindingCORSOnCompletion(Map<String, String> corsHeaders) {
            this.corsHeaders = corsHeaders;
        }

        @Override
        public void onAfterRoute(Route route, Exchange exchange) {
            String maxAge;
            String allowHeaders;
            String allowMethods;
            String allowOrigin;
            Message msg = exchange.hasOut() ? exchange.getOut() : exchange.getIn();
            String string = allowOrigin = this.corsHeaders != null ? this.corsHeaders.get("Access-Control-Allow-Origin") : null;
            if (allowOrigin == null) {
                allowOrigin = "*";
            }
            String string2 = allowMethods = this.corsHeaders != null ? this.corsHeaders.get("Access-Control-Allow-Methods") : null;
            if (allowMethods == null) {
                allowMethods = "GET, HEAD, POST, PUT, DELETE, TRACE, OPTIONS, CONNECT, PATCH";
            }
            String string3 = allowHeaders = this.corsHeaders != null ? this.corsHeaders.get("Access-Control-Allow-Headers") : null;
            if (allowHeaders == null) {
                allowHeaders = "Origin, Accept, X-Requested-With, Content-Type, Access-Control-Request-Method, Access-Control-Request-Headers";
            }
            String string4 = maxAge = this.corsHeaders != null ? this.corsHeaders.get("Access-Control-Max-Age") : null;
            if (maxAge == null) {
                maxAge = "3600";
            }
            msg.setHeader("Access-Control-Allow-Origin", allowOrigin);
            msg.setHeader("Access-Control-Allow-Methods", allowMethods);
            msg.setHeader("Access-Control-Allow-Headers", allowHeaders);
            msg.setHeader("Access-Control-Max-Age", maxAge);
        }

        public String toString() {
            return "RestBindingCORSOnCompletion";
        }
    }

    private final class RestBindingMarshalOnCompletion
    extends SynchronizationAdapter {
        private final AsyncProcessor jsonMarshal;
        private final AsyncProcessor xmlMarshal;
        private final String routeId;
        private boolean wasXml;
        private String accept;

        private RestBindingMarshalOnCompletion(String routeId, AsyncProcessor jsonMarshal, AsyncProcessor xmlMarshal, boolean wasXml, String accept) {
            this.routeId = routeId;
            this.jsonMarshal = jsonMarshal;
            this.xmlMarshal = xmlMarshal;
            this.wasXml = wasXml;
            this.accept = accept;
        }

        @Override
        public void onAfterRoute(Route route, Exchange exchange) {
            String contentType;
            if (!this.routeId.equals(route.getId())) {
                return;
            }
            if (exchange.getException() != null) {
                return;
            }
            if (RestBindingProcessor.this.skipBindingOnErrorCode) {
                Integer code;
                Integer n = code = exchange.hasOut() ? exchange.getOut().getHeader("CamelHttpResponseCode", Integer.class) : exchange.getIn().getHeader("CamelHttpResponseCode", Integer.class);
                if (code != null && code >= 300) {
                    return;
                }
            }
            boolean isXml = false;
            boolean isJson = false;
            if (this.accept != null) {
                isXml = this.accept.toLowerCase(Locale.ENGLISH).contains("xml");
                isJson = this.accept.toLowerCase(Locale.ENGLISH).contains("json");
            }
            if (!isXml && !isJson && (contentType = ExchangeHelper.getContentType(exchange)) != null) {
                isXml = contentType.toLowerCase(Locale.ENGLISH).contains("xml");
                isJson = contentType.toLowerCase(Locale.ENGLISH).contains("json");
            }
            if (!isXml && !isJson) {
                isXml = RestBindingProcessor.this.produces != null && RestBindingProcessor.this.produces.toLowerCase(Locale.ENGLISH).contains("xml");
                boolean bl = isJson = RestBindingProcessor.this.produces != null && RestBindingProcessor.this.produces.toLowerCase(Locale.ENGLISH).contains("json");
            }
            if (RestBindingProcessor.this.bindingMode != null && !(isJson &= RestBindingProcessor.this.bindingMode.equals("off") || RestBindingProcessor.this.bindingMode.equals("auto") || RestBindingProcessor.this.bindingMode.contains("json")) && !(isXml &= RestBindingProcessor.this.bindingMode.equals("off") || RestBindingProcessor.this.bindingMode.equals("auto") || RestBindingProcessor.this.bindingMode.contains("xml"))) {
                isXml = RestBindingProcessor.this.bindingMode.equals("auto") || RestBindingProcessor.this.bindingMode.contains("xml");
                boolean bl = isJson = RestBindingProcessor.this.bindingMode.equals("auto") || RestBindingProcessor.this.bindingMode.contains("json");
            }
            if (isXml && isJson) {
                isXml = this.wasXml;
                isJson = !this.wasXml;
            }
            ExchangeHelper.prepareOutToIn(exchange);
            this.ensureHeaderContentType(RestBindingProcessor.this.produces, isXml, isJson, exchange);
            if (RestBindingProcessor.this.bindingMode == null || "off".equals(RestBindingProcessor.this.bindingMode)) {
                return;
            }
            if (this.jsonMarshal == null && this.xmlMarshal == null) {
                return;
            }
            if (exchange.hasOut() && exchange.getOut().getBody() == null || !exchange.hasOut() && exchange.getIn().getBody() == null) {
                return;
            }
            contentType = exchange.getIn().getHeader("Content-Type", String.class);
            contentType = contentType.toLowerCase(Locale.US);
            try {
                if (isJson && this.jsonMarshal != null) {
                    if (contentType.contains("json")) {
                        this.jsonMarshal.process(exchange);
                    }
                } else if (isXml && this.xmlMarshal != null) {
                    if (contentType.contains("xml")) {
                        this.xmlMarshal.process(exchange);
                    }
                } else if (!RestBindingProcessor.this.bindingMode.equals("auto")) {
                    if (RestBindingProcessor.this.bindingMode.contains("xml")) {
                        exchange.setException(new BindingException("Cannot bind to xml as message body is not xml compatible", exchange));
                    } else {
                        exchange.setException(new BindingException("Cannot bind to json as message body is not json compatible", exchange));
                    }
                }
            }
            catch (Throwable e) {
                exchange.setException(e);
            }
        }

        private void ensureHeaderContentType(String contentType, boolean isXml, boolean isJson, Exchange exchange) {
            String type;
            if (contentType != null && (type = ExchangeHelper.getContentType(exchange)) == null) {
                exchange.getIn().setHeader("Content-Type", contentType);
            }
            if (isJson) {
                type = ExchangeHelper.getContentType(exchange);
                if (type == null) {
                    exchange.getIn().setHeader("Content-Type", "application/json");
                }
            } else if (isXml && (type = ExchangeHelper.getContentType(exchange)) == null) {
                exchange.getIn().setHeader("Content-Type", "application/xml");
            }
        }

        public String toString() {
            return "RestBindingMarshalOnCompletion";
        }
    }
}

