/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel;

import java.util.Map;
import javax.naming.Context;
import org.apache.camel.CamelContext;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.Service;
import org.apache.camel.TestSupport;
import org.apache.camel.builder.NotifyBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.Registry;
import org.apache.camel.util.jndi.JndiTest;

public abstract class ContextTestSupport
extends TestSupport {
    protected volatile ModelCamelContext context;
    protected volatile ProducerTemplate template;
    protected volatile ConsumerTemplate consumer;
    protected volatile NotifyBuilder oneExchangeDone;
    private boolean useRouteBuilder = true;
    private Service camelContextService;

    public boolean isUseRouteBuilder() {
        return this.useRouteBuilder;
    }

    public void setUseRouteBuilder(boolean useRouteBuilder) {
        this.useRouteBuilder = useRouteBuilder;
    }

    public Service getCamelContextService() {
        return this.camelContextService;
    }

    public void setCamelContextService(Service camelContextService) {
        this.camelContextService = camelContextService;
    }

    protected NotifyBuilder event() {
        return new NotifyBuilder((CamelContext)this.context);
    }

    protected void setUp() throws Exception {
        System.setProperty("CamelSedaPollTimeout", "10");
        if (!this.useJmx()) {
            this.disableJMX();
        } else {
            this.enableJMX();
        }
        CamelContext c2 = this.createCamelContext();
        if (!(c2 instanceof ModelCamelContext)) {
            throw new Exception("Context must be a ModelCamelContext");
        }
        this.context = (ModelCamelContext)c2;
        this.assertValidContext((CamelContext)this.context);
        this.context.getShutdownStrategy().setTimeout(10L);
        this.template = this.context.createProducerTemplate();
        this.template.start();
        this.consumer = this.context.createConsumerTemplate();
        this.consumer.start();
        this.oneExchangeDone = this.event().whenDone(1).create();
        if (this.isUseRouteBuilder()) {
            RouteBuilder[] builders;
            for (RouteBuilder builder : builders = this.createRouteBuilders()) {
                this.log.debug("Using created route builder: " + builder);
                this.context.addRoutes((RoutesBuilder)builder);
            }
            this.startCamelContext();
        } else {
            this.log.debug("isUseRouteBuilder() is false");
        }
    }

    protected void tearDown() throws Exception {
        this.log.debug("tearDown test: " + this.getName());
        if (this.consumer != null) {
            this.consumer.stop();
        }
        if (this.template != null) {
            this.template.stop();
        }
        this.stopCamelContext();
        System.clearProperty("org.apache.camel.jmx.disabled");
        System.clearProperty("CamelSedaPollTimeout");
    }

    protected boolean useJmx() {
        return false;
    }

    @Deprecated
    protected boolean isLazyLoadingTypeConverter() {
        return false;
    }

    protected void stopCamelContext() throws Exception {
        if (this.camelContextService != null) {
            this.camelContextService.stop();
        } else if (this.context != null) {
            this.context.stop();
        }
    }

    protected void startCamelContext() throws Exception {
        if (this.camelContextService != null) {
            this.camelContextService.start();
        } else if (this.context instanceof DefaultCamelContext) {
            DefaultCamelContext defaultCamelContext = (DefaultCamelContext)this.context;
            if (!defaultCamelContext.isStarted()) {
                defaultCamelContext.start();
            }
        } else {
            this.context.start();
        }
    }

    protected CamelContext createCamelContext() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext((Registry)this.createRegistry());
        context.setLazyLoadTypeConverters(Boolean.valueOf(this.isLazyLoadingTypeConverter()));
        return context;
    }

    protected JndiRegistry createRegistry() throws Exception {
        return new JndiRegistry(this.createJndiContext());
    }

    protected Context createJndiContext() throws Exception {
        return JndiTest.createInitialContext();
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() {
            }
        };
    }

    protected RouteBuilder[] createRouteBuilders() throws Exception {
        return new RouteBuilder[]{this.createRouteBuilder()};
    }

    protected Endpoint resolveMandatoryEndpoint(String uri) {
        return ContextTestSupport.resolveMandatoryEndpoint((CamelContext)this.context, uri);
    }

    protected <T extends Endpoint> T resolveMandatoryEndpoint(String uri, Class<T> endpointType) {
        return ContextTestSupport.resolveMandatoryEndpoint((CamelContext)this.context, uri, endpointType);
    }

    protected MockEndpoint getMockEndpoint(String uri) {
        return this.resolveMandatoryEndpoint(uri, MockEndpoint.class);
    }

    protected void sendBody(String endpointUri, final Object body) {
        this.template.send(endpointUri, new Processor(){

            public void process(Exchange exchange) {
                Message in = exchange.getIn();
                in.setBody(body);
                in.setHeader("testCase", (Object)ContextTestSupport.this.getName());
            }
        });
    }

    protected void sendBody(String endpointUri, final Object body, final Map<String, Object> headers) {
        this.template.send(endpointUri, new Processor(){

            public void process(Exchange exchange) {
                Message in = exchange.getIn();
                in.setBody(body);
                in.setHeader("testCase", (Object)ContextTestSupport.this.getName());
                for (Map.Entry entry : headers.entrySet()) {
                    in.setHeader((String)entry.getKey(), entry.getValue());
                }
            }
        });
    }

    protected void sendBodies(String endpointUri, Object ... bodies) {
        for (Object body : bodies) {
            this.sendBody(endpointUri, body);
        }
    }

    protected Exchange createExchangeWithBody(Object body) {
        return this.createExchangeWithBody((CamelContext)this.context, body);
    }

    protected void assertExpression(Exchange exchange, String languageName, String expressionText, Object expectedValue) {
        Language language = this.assertResolveLanguage(languageName);
        Expression expression = language.createExpression(expressionText);
        ContextTestSupport.assertNotNull((String)("No Expression could be created for text: " + expressionText + " language: " + language), (Object)expression);
        ContextTestSupport.assertExpression(expression, exchange, expectedValue);
    }

    protected void assertPredicate(String languageName, String expressionText, Exchange exchange, boolean expected) {
        Language language = this.assertResolveLanguage(languageName);
        Predicate predicate = language.createPredicate(expressionText);
        ContextTestSupport.assertNotNull((String)("No Predicate could be created for text: " + expressionText + " language: " + language), (Object)predicate);
        ContextTestSupport.assertPredicate(predicate, exchange, expected);
    }

    protected Language assertResolveLanguage(String languageName) {
        Language language = this.context.resolveLanguage(languageName);
        ContextTestSupport.assertNotNull((String)("No language found for name: " + languageName), (Object)language);
        return language;
    }

    protected void assertMockEndpointsSatisfied() throws InterruptedException {
        MockEndpoint.assertIsSatisfied((CamelContext)this.context);
    }

    protected void setAssertPeriod(long period) {
        MockEndpoint.setAssertPeriod((CamelContext)this.context, (long)period);
    }

    protected void resetMocks() {
        MockEndpoint.resetMocks((CamelContext)this.context);
    }

    protected void assertValidContext(CamelContext context) {
        ContextTestSupport.assertNotNull((String)"No context found!", (Object)context);
    }

    protected <T extends Endpoint> T getMandatoryEndpoint(String uri, Class<T> type) {
        Endpoint endpoint = this.context.getEndpoint(uri, type);
        ContextTestSupport.assertNotNull((String)("No endpoint found for uri: " + uri), (Object)endpoint);
        return (T)endpoint;
    }

    protected Endpoint getMandatoryEndpoint(String uri) {
        Endpoint endpoint = this.context.getEndpoint(uri);
        ContextTestSupport.assertNotNull((String)("No endpoint found for uri: " + uri), (Object)endpoint);
        return endpoint;
    }

    protected void disableJMX() {
        System.setProperty("org.apache.camel.jmx.disabled", "true");
    }

    protected void enableJMX() {
        System.setProperty("org.apache.camel.jmx.disabled", "false");
    }
}

