/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.MyBarSingleton;
import org.apache.camel.MyFoo;
import org.apache.camel.impl.DefaultInjector;
import org.apache.camel.spi.Injector;

public class InjectorDefaultsTest
extends ContextTestSupport {
    public void testInjectorIsDefaultByDefault() throws Exception {
        Injector injector = this.context.getInjector();
        InjectorDefaultsTest.assertIsInstanceOf(DefaultInjector.class, injector);
    }

    public void testNewInstance() throws Exception {
        Injector injector = this.context.getInjector();
        MyFoo foo = (MyFoo)injector.newInstance(MyFoo.class);
        foo.setName("Claus");
        MyFoo foo2 = (MyFoo)injector.newInstance(MyFoo.class);
        InjectorDefaultsTest.assertNotSame((Object)foo, (Object)foo2);
        InjectorDefaultsTest.assertEquals((String)"Claus", (String)foo.getName());
        InjectorDefaultsTest.assertNull((Object)foo2.getName());
    }

    public void testSharedInstance() throws Exception {
        Injector injector = this.context.getInjector();
        MyBarSingleton bar = (MyBarSingleton)injector.newInstance(MyBarSingleton.class, (Object)new MyBarSingleton());
        bar.setName("Claus");
        MyBarSingleton bar2 = (MyBarSingleton)injector.newInstance(MyBarSingleton.class, (Object)bar);
        InjectorDefaultsTest.assertSame((Object)bar, (Object)bar2);
        InjectorDefaultsTest.assertEquals((String)"Claus", (String)bar.getName());
        InjectorDefaultsTest.assertEquals((String)"Claus", (String)bar2.getName());
    }
}

