/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.TestCase;
import org.apache.camel.Rejectable;
import org.apache.camel.TestSupport;
import org.apache.camel.ThreadPoolRejectedPolicy;
import org.apache.camel.util.concurrent.RejectableThreadPoolExecutor;

public class ThreadPoolRejectedPolicyTest
extends TestSupport {
    public void testAbortAsRejectedExecutionHandler() throws InterruptedException {
        ExecutorService executorService = this.createTestExecutorService(ThreadPoolRejectedPolicy.Abort.asRejectedExecutionHandler());
        MockCallable task1 = new MockCallable();
        Future result1 = executorService.submit(task1);
        MockRunnable task2 = new MockRunnable();
        Future<?> result2 = executorService.submit(task2);
        MockCallable task3 = new MockCallable();
        try {
            executorService.submit(task3);
            ThreadPoolRejectedPolicyTest.fail((String)"Third task should have been rejected by a threadpool is full with 1 task and queue is full with 1 task.");
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
        this.shutdownAndAwait(executorService);
        this.assertInvoked(task1, result1);
        this.assertInvoked(task2, result2);
        this.assertRejected(task3, null);
    }

    public void testAbortAsRejectedExecutionHandlerWithRejectableTasks() throws InterruptedException {
        ExecutorService executorService = this.createTestExecutorService(ThreadPoolRejectedPolicy.Abort.asRejectedExecutionHandler());
        MockRejectableRunnable task1 = new MockRejectableRunnable();
        Future<?> result1 = executorService.submit(task1);
        MockRejectableCallable task2 = new MockRejectableCallable();
        Future result2 = executorService.submit(task2);
        MockRejectableRunnable task3 = new MockRejectableRunnable();
        Future<?> result3 = executorService.submit(task3);
        MockRejectableCallable task4 = new MockRejectableCallable();
        Future result4 = executorService.submit(task4);
        this.shutdownAndAwait(executorService);
        this.assertInvoked(task1, result1);
        this.assertInvoked(task2, result2);
        this.assertRejected(task3, result3);
        this.assertRejected(task4, result4);
    }

    public void testCallerRunsAsRejectedExecutionHandler() throws InterruptedException {
        ExecutorService executorService = this.createTestExecutorService(ThreadPoolRejectedPolicy.CallerRuns.asRejectedExecutionHandler());
        MockRunnable task1 = new MockRunnable();
        Future<?> result1 = executorService.submit(task1);
        MockRunnable task2 = new MockRunnable();
        Future<?> result2 = executorService.submit(task2);
        MockRunnable task3 = new MockRunnable();
        Future<?> result3 = executorService.submit(task3);
        this.shutdownAndAwait(executorService);
        this.assertInvoked(task1, result1);
        this.assertInvoked(task2, result2);
        this.assertInvoked(task3, result3);
    }

    public void testCallerRunsAsRejectedExecutionHandlerWithRejectableTasks() throws InterruptedException {
        ExecutorService executorService = this.createTestExecutorService(ThreadPoolRejectedPolicy.CallerRuns.asRejectedExecutionHandler());
        MockRejectableRunnable task1 = new MockRejectableRunnable();
        Future<?> result1 = executorService.submit(task1);
        MockRejectableRunnable task2 = new MockRejectableRunnable();
        Future<?> result2 = executorService.submit(task2);
        MockRejectableRunnable task3 = new MockRejectableRunnable();
        Future<?> result3 = executorService.submit(task3);
        this.shutdownAndAwait(executorService);
        this.assertInvoked(task1, result1);
        this.assertInvoked(task2, result2);
        this.assertInvoked(task3, result3);
    }

    public void testDiscardAsRejectedExecutionHandler() throws InterruptedException {
        ExecutorService executorService = this.createTestExecutorService(ThreadPoolRejectedPolicy.Discard.asRejectedExecutionHandler());
        MockRunnable task1 = new MockRunnable();
        Future<?> result1 = executorService.submit(task1);
        MockRunnable task2 = new MockRunnable();
        Future<?> result2 = executorService.submit(task2);
        MockRunnable task3 = new MockRunnable();
        Future<?> result3 = executorService.submit(task3);
        this.shutdownAndAwait(executorService);
        this.assertInvoked(task1, result1);
        this.assertInvoked(task2, result2);
        this.assertRejected(task3, result3);
    }

    public void testDiscardAsRejectedExecutionHandlerWithRejectableTasks() throws InterruptedException {
        ExecutorService executorService = this.createTestExecutorService(ThreadPoolRejectedPolicy.Discard.asRejectedExecutionHandler());
        MockRejectableRunnable task1 = new MockRejectableRunnable();
        Future<?> result1 = executorService.submit(task1);
        MockRejectableRunnable task2 = new MockRejectableRunnable();
        Future<?> result2 = executorService.submit(task2);
        MockRejectableRunnable task3 = new MockRejectableRunnable();
        Future<?> result3 = executorService.submit(task3);
        this.shutdownAndAwait(executorService);
        this.assertInvoked(task1, result1);
        this.assertInvoked(task2, result2);
        this.assertRejected(task3, result3);
    }

    public void testDiscardOldestAsRejectedExecutionHandler() throws InterruptedException {
        ExecutorService executorService = this.createTestExecutorService(ThreadPoolRejectedPolicy.DiscardOldest.asRejectedExecutionHandler());
        MockRunnable task1 = new MockRunnable();
        Future<?> result1 = executorService.submit(task1);
        MockRunnable task2 = new MockRunnable();
        Future<?> result2 = executorService.submit(task2);
        MockRunnable task3 = new MockRunnable();
        Future<?> result3 = executorService.submit(task3);
        this.shutdownAndAwait(executorService);
        this.assertInvoked(task1, result1);
        this.assertRejected(task2, result2);
        this.assertInvoked(task3, result3);
    }

    public void testDiscardOldestAsRejectedExecutionHandlerWithRejectableTasks() throws InterruptedException {
        ExecutorService executorService = this.createTestExecutorService(ThreadPoolRejectedPolicy.DiscardOldest.asRejectedExecutionHandler());
        MockRejectableRunnable task1 = new MockRejectableRunnable();
        Future<?> result1 = executorService.submit(task1);
        MockRejectableRunnable task2 = new MockRejectableRunnable();
        Future<?> result2 = executorService.submit(task2);
        MockRejectableRunnable task3 = new MockRejectableRunnable();
        Future<?> result3 = executorService.submit(task3);
        this.shutdownAndAwait(executorService);
        this.assertInvoked(task1, result1);
        this.assertRejected(task2, result2);
        this.assertInvoked(task3, result3);
    }

    private ExecutorService createTestExecutorService(RejectedExecutionHandler rejectedExecutionHandler) {
        return new RejectableThreadPoolExecutor(1, 1, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue(1), rejectedExecutionHandler);
    }

    private void shutdownAndAwait(ExecutorService executorService) {
        executorService.shutdown();
        try {
            ThreadPoolRejectedPolicyTest.assertTrue((String)"Test ExecutorService shutdown is not expected to take longer than 10 seconds.", (boolean)executorService.awaitTermination(10L, TimeUnit.SECONDS));
        }
        catch (InterruptedException e) {
            ThreadPoolRejectedPolicyTest.fail((String)"Test ExecutorService shutdown is not expected to be interrupted.");
        }
    }

    private void assertInvoked(MockTask task, Future<?> result) {
        ThreadPoolRejectedPolicyTest.assertTrue((boolean)result.isDone());
        ThreadPoolRejectedPolicyTest.assertEquals((int)1, (int)task.getInvocationCount());
        if (task instanceof Rejectable) {
            ThreadPoolRejectedPolicyTest.assertEquals((int)0, (int)task.getRejectionCount());
        }
    }

    private void assertRejected(MockTask task, Future<?> result) {
        if (result != null) {
            ThreadPoolRejectedPolicyTest.assertFalse((boolean)result.isDone());
        }
        ThreadPoolRejectedPolicyTest.assertEquals((int)0, (int)task.getInvocationCount());
        if (task instanceof Rejectable) {
            ThreadPoolRejectedPolicyTest.assertEquals((int)1, (int)task.getRejectionCount());
        }
    }

    private static class MockRejectableCallable<T>
    extends MockCallable<T>
    implements Rejectable {
        private MockRejectableCallable() {
        }

        public void reject() {
            this.countRejection();
        }
    }

    private static class MockCallable<T>
    extends MockTask
    implements Callable<T> {
        private MockCallable() {
        }

        @Override
        public T call() throws Exception {
            this.countInvocation();
            try {
                TimeUnit.MILLISECONDS.sleep(100L);
            }
            catch (InterruptedException e) {
                TestCase.fail((String)"MockCallable task is not expected to be interrupted.");
            }
            return null;
        }
    }

    private static class MockRejectableRunnable
    extends MockRunnable
    implements Rejectable {
        private MockRejectableRunnable() {
        }

        public void reject() {
            this.countRejection();
        }
    }

    private static class MockRunnable
    extends MockTask
    implements Runnable {
        private MockRunnable() {
        }

        @Override
        public void run() {
            this.countInvocation();
            try {
                TimeUnit.MILLISECONDS.sleep(100L);
            }
            catch (InterruptedException e) {
                TestCase.fail((String)"MockRunnable task is not expected to be interrupted.");
            }
        }
    }

    private static abstract class MockTask {
        private final AtomicInteger invocationCount = new AtomicInteger();
        private final AtomicInteger rejectionCount = new AtomicInteger();

        private MockTask() {
        }

        public int getInvocationCount() {
            return this.invocationCount.get();
        }

        protected void countInvocation() {
            this.invocationCount.incrementAndGet();
        }

        public int getRejectionCount() {
            return this.rejectionCount.get();
        }

        protected void countRejection() {
            this.rejectionCount.incrementAndGet();
        }
    }
}

