/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder;

import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.Predicate;
import org.apache.camel.TestSupport;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.builder.PredicateBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.DefaultExchange;

public class PredicateBinaryCoerceTypeTest
extends TestSupport {
    protected Exchange exchange = new DefaultExchange((CamelContext)new DefaultCamelContext());

    public void testIsNull() throws Exception {
        Expression a = ExpressionBuilder.constantExpression((Object)"123");
        this.assertDoesNotMatch(PredicateBuilder.isNull((Expression)a));
        a = ExpressionBuilder.constantExpression(null);
        this.assertMatches(PredicateBuilder.isNull((Expression)a));
    }

    public void testIsNotNull() throws Exception {
        Expression a = ExpressionBuilder.constantExpression((Object)"123");
        this.assertMatches(PredicateBuilder.isNotNull((Expression)a));
        a = ExpressionBuilder.constantExpression(null);
        this.assertDoesNotMatch(PredicateBuilder.isNotNull((Expression)a));
    }

    public void testEqual() throws Exception {
        Expression a = ExpressionBuilder.constantExpression((Object)"123");
        Expression b = ExpressionBuilder.constantExpression((Object)Integer.valueOf("123"));
        this.assertMatches(PredicateBuilder.isEqualTo((Expression)a, (Expression)b));
        a = ExpressionBuilder.constantExpression((Object)Integer.valueOf("123"));
        b = ExpressionBuilder.constantExpression((Object)"123");
        this.assertMatches(PredicateBuilder.isEqualTo((Expression)a, (Expression)b));
    }

    public void testEqualWithNull() throws Exception {
        Expression a = ExpressionBuilder.constantExpression((Object)"123");
        Expression b = ExpressionBuilder.constantExpression(null);
        this.assertDoesNotMatch(PredicateBuilder.isEqualTo((Expression)a, (Expression)b));
        a = ExpressionBuilder.constantExpression(null);
        b = ExpressionBuilder.constantExpression((Object)"123");
        this.assertDoesNotMatch(PredicateBuilder.isEqualTo((Expression)a, (Expression)b));
        a = ExpressionBuilder.constantExpression(null);
        b = ExpressionBuilder.constantExpression(null);
        this.assertMatches(PredicateBuilder.isEqualTo((Expression)a, (Expression)b));
    }

    public void testNotEqual() throws Exception {
        Expression a = ExpressionBuilder.constantExpression((Object)"123");
        Expression b = ExpressionBuilder.constantExpression((Object)Integer.valueOf("123"));
        this.assertDoesNotMatch(PredicateBuilder.isNotEqualTo((Expression)a, (Expression)b));
        a = ExpressionBuilder.constantExpression((Object)"333");
        this.assertMatches(PredicateBuilder.isNotEqualTo((Expression)a, (Expression)b));
    }

    public void testNotEqualWithNull() throws Exception {
        Expression a = ExpressionBuilder.constantExpression((Object)"123");
        Expression b = ExpressionBuilder.constantExpression(null);
        this.assertMatches(PredicateBuilder.isNotEqualTo((Expression)a, (Expression)b));
        a = ExpressionBuilder.constantExpression(null);
        b = ExpressionBuilder.constantExpression((Object)"123");
        this.assertMatches(PredicateBuilder.isNotEqualTo((Expression)a, (Expression)b));
        a = ExpressionBuilder.constantExpression(null);
        b = ExpressionBuilder.constantExpression(null);
        this.assertDoesNotMatch(PredicateBuilder.isNotEqualTo((Expression)a, (Expression)b));
    }

    public void testGreatherThan() throws Exception {
        Expression a = ExpressionBuilder.constantExpression((Object)"200");
        Expression b = ExpressionBuilder.constantExpression((Object)Integer.valueOf("100"));
        this.assertMatches(PredicateBuilder.isGreaterThan((Expression)a, (Expression)b));
        this.assertDoesNotMatch(PredicateBuilder.isGreaterThan((Expression)b, (Expression)a));
        a = ExpressionBuilder.constantExpression((Object)Integer.valueOf("100"));
        b = ExpressionBuilder.constantExpression((Object)"200");
        this.assertDoesNotMatch(PredicateBuilder.isGreaterThan((Expression)a, (Expression)b));
        this.assertMatches(PredicateBuilder.isGreaterThan((Expression)b, (Expression)a));
    }

    public void testGreatherThanOrEqual() throws Exception {
        Expression a = ExpressionBuilder.constantExpression((Object)"200");
        Expression b = ExpressionBuilder.constantExpression((Object)Integer.valueOf("100"));
        this.assertMatches(PredicateBuilder.isGreaterThanOrEqualTo((Expression)a, (Expression)b));
        this.assertDoesNotMatch(PredicateBuilder.isGreaterThanOrEqualTo((Expression)b, (Expression)a));
        a = ExpressionBuilder.constantExpression((Object)Integer.valueOf("100"));
        b = ExpressionBuilder.constantExpression((Object)"200");
        this.assertDoesNotMatch(PredicateBuilder.isGreaterThanOrEqualTo((Expression)a, (Expression)b));
        this.assertMatches(PredicateBuilder.isGreaterThanOrEqualTo((Expression)b, (Expression)a));
        a = ExpressionBuilder.constantExpression((Object)"100");
        b = ExpressionBuilder.constantExpression((Object)Integer.valueOf("100"));
        this.assertMatches(PredicateBuilder.isGreaterThanOrEqualTo((Expression)a, (Expression)b));
        this.assertMatches(PredicateBuilder.isGreaterThanOrEqualTo((Expression)b, (Expression)a));
        a = ExpressionBuilder.constantExpression((Object)Integer.valueOf("100"));
        b = ExpressionBuilder.constantExpression((Object)"100");
        this.assertMatches(PredicateBuilder.isGreaterThanOrEqualTo((Expression)a, (Expression)b));
        this.assertMatches(PredicateBuilder.isGreaterThanOrEqualTo((Expression)b, (Expression)a));
    }

    public void testLessThan() throws Exception {
        Expression a = ExpressionBuilder.constantExpression((Object)"100");
        Expression b = ExpressionBuilder.constantExpression((Object)Integer.valueOf("200"));
        this.assertMatches(PredicateBuilder.isLessThan((Expression)a, (Expression)b));
        this.assertDoesNotMatch(PredicateBuilder.isLessThan((Expression)b, (Expression)a));
        a = ExpressionBuilder.constantExpression((Object)Integer.valueOf("100"));
        b = ExpressionBuilder.constantExpression((Object)"200");
        this.assertMatches(PredicateBuilder.isLessThan((Expression)a, (Expression)b));
        this.assertDoesNotMatch(PredicateBuilder.isLessThan((Expression)b, (Expression)a));
    }

    public void testLessThanOrEqual() throws Exception {
        Expression a = ExpressionBuilder.constantExpression((Object)"100");
        Expression b = ExpressionBuilder.constantExpression((Object)Integer.valueOf("200"));
        this.assertMatches(PredicateBuilder.isLessThanOrEqualTo((Expression)a, (Expression)b));
        this.assertDoesNotMatch(PredicateBuilder.isLessThanOrEqualTo((Expression)b, (Expression)a));
        a = ExpressionBuilder.constantExpression((Object)Integer.valueOf("200"));
        b = ExpressionBuilder.constantExpression((Object)"100");
        this.assertDoesNotMatch(PredicateBuilder.isLessThanOrEqualTo((Expression)a, (Expression)b));
        this.assertMatches(PredicateBuilder.isLessThanOrEqualTo((Expression)b, (Expression)a));
        a = ExpressionBuilder.constantExpression((Object)"100");
        b = ExpressionBuilder.constantExpression((Object)Integer.valueOf("100"));
        this.assertMatches(PredicateBuilder.isLessThanOrEqualTo((Expression)a, (Expression)b));
        this.assertMatches(PredicateBuilder.isLessThanOrEqualTo((Expression)b, (Expression)a));
        a = ExpressionBuilder.constantExpression((Object)Integer.valueOf("100"));
        b = ExpressionBuilder.constantExpression((Object)"100");
        this.assertMatches(PredicateBuilder.isGreaterThanOrEqualTo((Expression)a, (Expression)b));
        this.assertMatches(PredicateBuilder.isGreaterThanOrEqualTo((Expression)b, (Expression)a));
    }

    protected void setUp() throws Exception {
        super.setUp();
        Message in = this.exchange.getIn();
        in.setBody((Object)"Hello there!");
        in.setHeader("name", (Object)"James");
        in.setHeader("location", (Object)"Islington,London,UK");
        in.setHeader("size", (Object)10);
    }

    protected void assertMatches(Predicate predicate) {
        PredicateBinaryCoerceTypeTest.assertPredicateMatches(predicate, this.exchange);
    }

    protected void assertDoesNotMatch(Predicate predicate) {
        PredicateBinaryCoerceTypeTest.assertPredicateDoesNotMatch(predicate, this.exchange);
    }
}

