/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.sax.SAXSource;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.ExpectedBodyTypeException;
import org.apache.camel.builder.xml.StreamResultHandlerFactory;
import org.apache.camel.builder.xml.XsltBuilder;
import org.apache.camel.converter.jaxp.XmlConverter;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.util.UnitOfWorkHelper;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class XsltBuilderTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        XsltBuilderTest.deleteDirectory("target/xslt");
        XsltBuilderTest.createDirectory("target/xslt");
        super.setUp();
    }

    public void testXsltUrl() throws Exception {
        URL styleSheet = ((Object)((Object)this)).getClass().getResource("example.xsl");
        XsltBuilder builder = XsltBuilder.xslt((URL)styleSheet);
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setBody((Object)"<hello>world!</hello>");
        builder.process((Exchange)exchange);
        XsltBuilderTest.assertEquals((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><goodbye>world!</goodbye>", (Object)exchange.getOut().getBody());
    }

    public void testXsltTransformerUrl() throws Exception {
        URL styleSheet = ((Object)((Object)this)).getClass().getResource("example.xsl");
        XsltBuilder builder = new XsltBuilder();
        builder.setTransformerURL(styleSheet);
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setBody((Object)"<hello>world!</hello>");
        builder.process((Exchange)exchange);
        XsltBuilderTest.assertEquals((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><goodbye>world!</goodbye>", (Object)exchange.getOut().getBody());
    }

    public void testXsltFile() throws Exception {
        File styleSheet = new File("src/test/resources/org/apache/camel/builder/xml/example.xsl");
        XsltBuilder builder = XsltBuilder.xslt((File)styleSheet);
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setBody((Object)"<hello>world!</hello>");
        builder.process((Exchange)exchange);
        XsltBuilderTest.assertEquals((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><goodbye>world!</goodbye>", (Object)exchange.getOut().getBody());
    }

    public void testXsltTransformerFile() throws Exception {
        File styleSheet = new File("src/test/resources/org/apache/camel/builder/xml/example.xsl");
        XsltBuilder builder = new XsltBuilder();
        builder.setTransformerFile(styleSheet);
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setBody((Object)"<hello>world!</hello>");
        builder.process((Exchange)exchange);
        XsltBuilderTest.assertEquals((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><goodbye>world!</goodbye>", (Object)exchange.getOut().getBody());
    }

    public void testXsltInputStream() throws Exception {
        File styleSheet = new File("src/test/resources/org/apache/camel/builder/xml/example.xsl");
        XsltBuilder builder = XsltBuilder.xslt((InputStream)new FileInputStream(styleSheet));
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setBody((Object)"<hello>world!</hello>");
        builder.process((Exchange)exchange);
        XsltBuilderTest.assertEquals((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><goodbye>world!</goodbye>", (Object)exchange.getOut().getBody());
    }

    public void testXsltTransformerInputStream() throws Exception {
        File styleSheet = new File("src/test/resources/org/apache/camel/builder/xml/example.xsl");
        XsltBuilder builder = new XsltBuilder();
        builder.setTransformerInputStream((InputStream)new FileInputStream(styleSheet));
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setBody((Object)"<hello>world!</hello>");
        builder.process((Exchange)exchange);
        XsltBuilderTest.assertEquals((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><goodbye>world!</goodbye>", (Object)exchange.getOut().getBody());
    }

    public void testXsltSource() throws Exception {
        File file = new File("src/test/resources/org/apache/camel/builder/xml/example.xsl");
        SAXSource styleSheet = new SAXSource(new InputSource(new FileInputStream(file)));
        XsltBuilder builder = XsltBuilder.xslt((Source)styleSheet);
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setBody((Object)"<hello>world!</hello>");
        builder.process((Exchange)exchange);
        XsltBuilderTest.assertEquals((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><goodbye>world!</goodbye>", (Object)exchange.getOut().getBody());
    }

    public void testXsltTemplates() throws Exception {
        File file = new File("src/test/resources/org/apache/camel/builder/xml/example.xsl");
        SAXSource source = new SAXSource(new InputSource(new FileInputStream(file)));
        XmlConverter converter = new XmlConverter();
        Templates styleSheet = converter.getTransformerFactory().newTemplates(source);
        XsltBuilder builder = XsltBuilder.xslt((Templates)styleSheet);
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setBody((Object)"<hello>world!</hello>");
        builder.process((Exchange)exchange);
        XsltBuilderTest.assertEquals((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><goodbye>world!</goodbye>", (Object)exchange.getOut().getBody());
    }

    public void testXsltOutputString() throws Exception {
        URL styleSheet = ((Object)((Object)this)).getClass().getResource("example.xsl");
        XsltBuilder builder = XsltBuilder.xslt((URL)styleSheet).outputString();
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setBody((Object)"<hello>world!</hello>");
        builder.process((Exchange)exchange);
        XsltBuilderTest.assertIsInstanceOf(String.class, exchange.getOut().getBody());
        XsltBuilderTest.assertEquals((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><goodbye>world!</goodbye>", (Object)exchange.getOut().getBody());
    }

    public void testXsltOutputBytes() throws Exception {
        URL styleSheet = ((Object)((Object)this)).getClass().getResource("example.xsl");
        XsltBuilder builder = XsltBuilder.xslt((URL)styleSheet).outputBytes();
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setBody((Object)"<hello>world!</hello>");
        builder.process((Exchange)exchange);
        XsltBuilderTest.assertIsInstanceOf(byte[].class, exchange.getOut().getBody());
        XsltBuilderTest.assertEquals((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><goodbye>world!</goodbye>", (String)((String)exchange.getOut().getBody(String.class)));
    }

    public void testXsltOutputDOM() throws Exception {
        URL styleSheet = ((Object)((Object)this)).getClass().getResource("example.xsl");
        XsltBuilder builder = XsltBuilder.xslt((URL)styleSheet).outputDOM();
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setBody((Object)"<hello>world!</hello>");
        builder.process((Exchange)exchange);
        XsltBuilderTest.assertIsInstanceOf(Document.class, exchange.getOut().getBody());
        XsltBuilderTest.assertEquals((String)"<goodbye>world!</goodbye>", (String)((String)exchange.getOut().getBody(String.class)));
    }

    public void testXsltOutputFile() throws Exception {
        URL styleSheet = ((Object)((Object)this)).getClass().getResource("example.xsl");
        XsltBuilder builder = XsltBuilder.xslt((URL)styleSheet).outputFile();
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setBody((Object)"<hello>world!</hello>");
        exchange.getIn().setHeader("CamelXsltFileName", (Object)"target/xslt/xsltout.xml");
        builder.process((Exchange)exchange);
        XsltBuilderTest.assertIsInstanceOf(File.class, exchange.getOut().getBody());
        File file = new File("target/xslt/xsltout.xml");
        XsltBuilderTest.assertTrue((String)"Output file should exist", (boolean)file.exists());
        String body = (String)exchange.getOut().getBody(String.class);
        XsltBuilderTest.assertTrue((boolean)body.endsWith("<goodbye>world!</goodbye>"));
    }

    public void testXsltOutputFileDelete() throws Exception {
        URL styleSheet = ((Object)((Object)this)).getClass().getResource("example.xsl");
        XsltBuilder builder = XsltBuilder.xslt((URL)styleSheet).outputFile().deleteOutputFile();
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setBody((Object)"<hello>world!</hello>");
        exchange.getIn().setHeader("CamelXsltFileName", (Object)"target/xslt/xsltout.xml");
        builder.process((Exchange)exchange);
        XsltBuilderTest.assertIsInstanceOf(File.class, exchange.getOut().getBody());
        File file = new File("target/xslt/xsltout.xml");
        XsltBuilderTest.assertTrue((String)"Output file should exist", (boolean)file.exists());
        String body = (String)exchange.getOut().getBody(String.class);
        XsltBuilderTest.assertTrue((boolean)body.endsWith("<goodbye>world!</goodbye>"));
        List onCompletions = exchange.handoverCompletions();
        UnitOfWorkHelper.doneSynchronizations((Exchange)exchange, (List)onCompletions, (Logger)this.log);
        XsltBuilderTest.assertFalse((String)"Output file should be deleted", (boolean)file.exists());
    }

    public void testXsltSetConverter() throws Exception {
        URL styleSheet = ((Object)((Object)this)).getClass().getResource("example.xsl");
        XsltBuilder builder = XsltBuilder.xslt((URL)styleSheet);
        XmlConverter converter = new XmlConverter();
        builder.setConverter(converter);
        XsltBuilderTest.assertSame((Object)converter, (Object)builder.getConverter());
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setBody((Object)"<hello>world!</hello>");
        builder.process((Exchange)exchange);
        XsltBuilderTest.assertEquals((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><goodbye>world!</goodbye>", (Object)exchange.getOut().getBody());
    }

    public void testXsltResultHandler() throws Exception {
        URL styleSheet = ((Object)((Object)this)).getClass().getResource("example.xsl");
        XsltBuilder builder = XsltBuilder.xslt((URL)styleSheet);
        XsltBuilderTest.assertNotNull((Object)builder.getResultHandlerFactory());
        builder.outputBytes();
        XsltBuilderTest.assertIsInstanceOf(StreamResultHandlerFactory.class, builder.getResultHandlerFactory());
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setBody((Object)"<hello>world!</hello>");
        builder.process((Exchange)exchange);
        XsltBuilderTest.assertEquals((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><goodbye>world!</goodbye>", (String)((String)exchange.getOut().getBody(String.class)));
    }

    public void testNullBodyDefault() throws Exception {
        URL styleSheet = ((Object)((Object)this)).getClass().getResource("example.xsl");
        XsltBuilder builder = XsltBuilder.xslt((URL)styleSheet);
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setBody(null);
        try {
            builder.process((Exchange)exchange);
            XsltBuilderTest.fail((String)"Should thrown an exception");
        }
        catch (ExpectedBodyTypeException expectedBodyTypeException) {
            // empty catch block
        }
    }

    public void testFailNullBody() throws Exception {
        URL styleSheet = ((Object)((Object)this)).getClass().getResource("example.xsl");
        XsltBuilder builder = XsltBuilder.xslt((URL)styleSheet);
        builder.setFailOnNullBody(true);
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setBody(null);
        try {
            builder.process((Exchange)exchange);
            XsltBuilderTest.fail((String)"Should thrown an exception");
        }
        catch (ExpectedBodyTypeException expectedBodyTypeException) {
            // empty catch block
        }
    }

    public void testNotFailNullBody() throws Exception {
        URL styleSheet = ((Object)((Object)this)).getClass().getResource("example.xsl");
        XsltBuilder builder = XsltBuilder.xslt((URL)styleSheet);
        builder.setFailOnNullBody(false);
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.getIn().setBody(null);
        builder.process((Exchange)exchange);
        XsltBuilderTest.assertEquals((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><goodbye/>", (String)((String)exchange.getOut().getBody(String.class)));
    }
}

