/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.ComponentConfiguration;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.EndpointConfiguration;
import org.apache.camel.component.bean.BeanComponent;
import org.apache.camel.impl.DefaultCamelContext;
import org.junit.Test;

public class BeanComponentConfigurationAndDocumentationTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testComponentConfiguration() throws Exception {
        BeanComponent comp = (BeanComponent)this.context.getComponent("bean", BeanComponent.class);
        EndpointConfiguration conf = comp.createConfiguration("bean:foo?method=bar");
        BeanComponentConfigurationAndDocumentationTest.assertEquals((Object)"bar", (Object)conf.getParameter("method"));
        ComponentConfiguration compConf = comp.createComponentConfiguration();
        String json = compConf.createParameterJsonSchema();
        BeanComponentConfigurationAndDocumentationTest.assertNotNull((Object)json);
        BeanComponentConfigurationAndDocumentationTest.assertTrue((boolean)json.contains("\"method\": { \"kind\": \"parameter\", \"group\": \"producer\", \"type\": \"string\""));
        BeanComponentConfigurationAndDocumentationTest.assertTrue((boolean)json.contains("\"cache\": { \"kind\": \"parameter\", \"group\": \"advanced\", \"label\": \"advanced\", \"type\": \"boolean\""));
    }

    @Test
    public void testComponentDocumentation() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        String html = context.getComponentDocumentation("bean");
        BeanComponentConfigurationAndDocumentationTest.assertNotNull((String)"Should have found some auto-generated HTML", (Object)html);
    }
}

