/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.RouteDefinition;

public class BeanExpressionConcurrentTest
extends ContextTestSupport {
    public void testBeanConcurrent() throws Exception {
        int i;
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1000);
        mock.expectsNoDuplicates((Expression)BeanExpressionConcurrentTest.body());
        for (int i2 = 1000; i2 < 2000; ++i2) {
            this.template.sendBody("seda:foo", (Object)("" + i2));
        }
        this.context.startRoute("foo");
        this.assertMockEndpointsSatisfied();
        ArrayList<String> list = new ArrayList<String>();
        for (i = 0; i < 1000; ++i) {
            String body = (String)((Exchange)mock.getReceivedExchanges().get(i)).getIn().getBody(String.class);
            list.add(body);
        }
        Collections.sort(list);
        BeanExpressionConcurrentTest.assertEquals((int)1000, (int)list.size());
        for (i = 1; i < 1000; ++i) {
            int num = 1000 + i;
            String s = "" + num + " " + num;
            BeanExpressionConcurrentTest.assertEquals((String)s, (String)((String)list.get(i)));
        }
    }

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("myBean", (Object)new MyBean());
        return jndi;
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("seda:foo?concurrentConsumers=10").routeId("foo").noAutoStartup().transform((Expression)this.method("myBean"))).to("mock:result");
            }
        };
    }

    private static class MyBean {
        private String foo;
        private String bar;
        private int baz;

        private MyBean() {
        }

        public String getFoo() {
            return this.foo;
        }

        public void setFoo(String foo) {
            this.foo = foo;
        }

        public String getBar() {
            return this.bar;
        }

        public void setBar(String bar) {
            this.bar = bar;
        }

        public int getBaz() {
            return this.baz;
        }

        public void setBaz(int baz) {
            this.baz = baz;
        }

        public void doSomething() {
        }

        public String echo(String s) {
            return s + " " + s;
        }

        public String toString() {
            return "MyBean";
        }
    }
}

