/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.lang.reflect.Method;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.bean.AmbiguousMethodCallException;
import org.apache.camel.component.bean.BeanInfo;
import org.apache.camel.component.bean.MethodInvocation;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.impl.DefaultMessage;

public class BeanInfoAMoreComplexOverloadedTest
extends ContextTestSupport {
    public void testRequestA() throws Exception {
        BeanInfo beanInfo = new BeanInfo((CamelContext)this.context, Bean.class);
        DefaultMessage message = new DefaultMessage();
        message.setBody((Object)new RequestA());
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.setIn((Message)message);
        MethodInvocation methodInvocation = beanInfo.createInvocation((Object)new Bean(), (Exchange)exchange);
        Method method = methodInvocation.getMethod();
        BeanInfoAMoreComplexOverloadedTest.assertEquals((String)"doSomething", (String)method.getName());
        BeanInfoAMoreComplexOverloadedTest.assertEquals(RequestA.class, (Object)method.getGenericParameterTypes()[0]);
    }

    public void testRequestB() throws Exception {
        BeanInfo beanInfo = new BeanInfo((CamelContext)this.context, Bean.class);
        DefaultMessage message = new DefaultMessage();
        message.setBody((Object)new RequestB());
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.setIn((Message)message);
        MethodInvocation methodInvocation = beanInfo.createInvocation((Object)new Bean(), (Exchange)exchange);
        Method method = methodInvocation.getMethod();
        BeanInfoAMoreComplexOverloadedTest.assertEquals((String)"doSomething", (String)method.getName());
        BeanInfoAMoreComplexOverloadedTest.assertEquals(RequestB.class, (Object)method.getGenericParameterTypes()[0]);
    }

    public void testAmbigious() throws Exception {
        BeanInfo beanInfo = new BeanInfo((CamelContext)this.context, Bean.class);
        DefaultMessage message = new DefaultMessage();
        message.setBody((Object)"Hello World");
        DefaultExchange exchange = new DefaultExchange((CamelContext)this.context);
        exchange.setIn((Message)message);
        try {
            beanInfo.createInvocation((Object)new Bean(), (Exchange)exchange);
            BeanInfoAMoreComplexOverloadedTest.fail((String)"Should have thrown an exception");
        }
        catch (AmbiguousMethodCallException e) {
            BeanInfoAMoreComplexOverloadedTest.assertEquals((int)2, (int)e.getMethods().size());
        }
    }

    class RequestB
    extends BaseRequest {
        public String s;

        RequestB() {
        }
    }

    class RequestA
    extends BaseRequest {
        public int i;

        RequestA() {
        }
    }

    class BaseRequest {
        public long id;

        BaseRequest() {
        }
    }

    class Bean {
        Bean() {
        }

        public void doSomething(RequestA request) {
        }

        public void doSomething(RequestB request) {
        }
    }
}

