/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.naming.Context;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.util.jndi.JndiContext;

public class BeanMethodWithExchangeTest
extends ContextTestSupport {
    public void testBeanWithAnnotationAndExchangeTest() throws Exception {
        Exchange result = this.template.request("direct:start1", new Processor(){

            public void process(Exchange exchange) throws Exception {
                Message m = exchange.getIn();
                m.addAttachment("attachment", new DataHandler((DataSource)new FileDataSource("src/test/org/apache/camel/component/bean/BeanWithAttachmentAnnotationTest.java")));
            }
        });
        BeanMethodWithExchangeTest.assertTrue((boolean)result.getOut().getAttachments().containsKey("attachment2"));
        BeanMethodWithExchangeTest.assertFalse((boolean)result.getOut().getAttachments().containsKey("attachment"));
    }

    @Override
    protected Context createJndiContext() throws Exception {
        JndiContext answer = new JndiContext();
        answer.bind("processor", (Object)new AttachmentProcessor());
        return answer;
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start1").to("bean:processor");
            }
        };
    }

    public static class AttachmentProcessor {
        public void doSomething(Exchange exchange) {
            exchange.getOut().addAttachment("attachment2", new DataHandler((DataSource)new FileDataSource("src/test/org/apache/camel/component/bean/BeanMethodWithExchangeTest.java")));
        }
    }
}

