/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.bean.BeanWithHeaderAnnotation;
import org.apache.camel.component.bean.ParameterBindingException;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.w3c.dom.Document;

public class BeanNoTypeConvertionPossibleWhenHeaderTest
extends ContextTestSupport {
    public void testBeanHeaderNoTypeConvertionPossibleFail() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        try {
            this.template.requestBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)555);
            BeanNoTypeConvertionPossibleWhenHeaderTest.fail((String)"Should have thrown an exception");
        }
        catch (CamelExecutionException e) {
            ParameterBindingException pbe = BeanNoTypeConvertionPossibleWhenHeaderTest.assertIsInstanceOf(ParameterBindingException.class, e.getCause());
            BeanNoTypeConvertionPossibleWhenHeaderTest.assertEquals((int)1, (int)pbe.getIndex());
            BeanNoTypeConvertionPossibleWhenHeaderTest.assertTrue((boolean)pbe.getMethod().getName().contains("hello"));
            BeanNoTypeConvertionPossibleWhenHeaderTest.assertEquals((Object)555, (Object)pbe.getParameterValue());
            NoTypeConversionAvailableException ntae = BeanNoTypeConvertionPossibleWhenHeaderTest.assertIsInstanceOf(NoTypeConversionAvailableException.class, e.getCause().getCause());
            BeanNoTypeConvertionPossibleWhenHeaderTest.assertEquals(Integer.class, (Object)ntae.getFromType());
            BeanNoTypeConvertionPossibleWhenHeaderTest.assertEquals(Document.class, (Object)ntae.getToType());
            BeanNoTypeConvertionPossibleWhenHeaderTest.assertEquals((Object)555, (Object)ntae.getValue());
            BeanNoTypeConvertionPossibleWhenHeaderTest.assertNotNull((Object)ntae.getMessage());
        }
        this.assertMockEndpointsSatisfied();
    }

    public void testBeanHeaderNoTypeConvertionPossibleOK() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.requestBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)"<?xml version=\"1.0\"?><foo>bar</foo>");
        this.assertMockEndpointsSatisfied();
    }

    public void testBeanHeaderNoTypeConvertionPossibleOKNullHeader() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        ((ValueBuilder)mock.message(0).header("foo")).isNull();
        this.template.requestBodyAndHeader("direct:start", (Object)"Hello World", "foo", (Object)null);
        this.assertMockEndpointsSatisfied();
    }

    public void testBeanHeaderNoTypeConvertionPossibleOKNoHeader() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        ((ValueBuilder)mock.message(0).header("foo")).isNull();
        this.template.requestBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:start").bean(BeanWithHeaderAnnotation.class)).to("mock:result");
            }
        };
    }
}

