/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.util.Map;
import javax.naming.Context;
import junit.framework.TestCase;
import org.apache.camel.Body;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Headers;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.util.jndi.JndiContext;

public class BeanPipelineTest
extends ContextTestSupport {
    public void testBeanInPipeline() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World from James"});
        mock.expectedHeaderReceived("from", (Object)"James");
        this.template.sendBodyAndHeader("direct:input", (Object)"Hello World", "from", (Object)"Claus");
        mock.assertIsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:input").pipeline(new String[]{"bean:foo", "bean:bar?method=usingExchange", "bean:baz"})).to("mock:result");
            }
        };
    }

    @Override
    protected Context createJndiContext() throws Exception {
        JndiContext answer = new JndiContext();
        answer.bind("foo", (Object)new FooBean());
        answer.bind("bar", (Object)new BarBean());
        answer.bind("baz", (Object)new BazBean());
        return answer;
    }

    public static class BazBean {
        public void doNotUseMe(String body) {
            TestCase.fail((String)"Should not invoce me");
        }

        public void withAnnotations(@Headers Map<String, Object> headers, @Body String body) {
            TestCase.assertEquals((String)"Hello World from James", (String)body);
            TestCase.assertEquals((Object)"James", (Object)headers.get("from"));
        }
    }

    public static class BarBean {
        public void doNotUseMe(String body) {
            TestCase.fail((String)"Should not invoce me");
        }

        public void usingExchange(Exchange exchange) {
            String body = (String)exchange.getIn().getBody(String.class);
            TestCase.assertEquals((String)"Hello World", (String)body);
            TestCase.assertEquals((Object)"Claus", (Object)exchange.getIn().getHeader("from"));
            exchange.getOut().setHeader("from", (Object)"James");
            exchange.getOut().setBody((Object)"Hello World from James");
        }
    }

    public static class FooBean {
        public void onlyPlainBody(Object body) {
            TestCase.assertEquals((Object)"Hello World", (Object)body);
        }
    }
}

