/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.bean.ProxyHelper;

public class ProxyReturnFutureExceptionTest
extends ContextTestSupport {
    public void testFutureEchoException() throws Exception {
        Echo service = (Echo)ProxyHelper.createProxy((Endpoint)this.context.getEndpoint("direct:echo"), Echo.class);
        Future<String> future = service.asText(4);
        this.log.info("Got future");
        this.log.info("Waiting for future to be done ...");
        try {
            ProxyReturnFutureExceptionTest.assertEquals((String)"Four", (String)future.get(5L, TimeUnit.SECONDS));
            ProxyReturnFutureExceptionTest.fail((String)"Should have thrown exception");
        }
        catch (ExecutionException e) {
            IllegalArgumentException cause = ProxyReturnFutureExceptionTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
            ProxyReturnFutureExceptionTest.assertEquals((String)"Forced", (String)cause.getMessage());
        }
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:echo").delay(250L).throwException((Exception)new IllegalArgumentException("Forced"));
            }
        };
    }

    public static interface Echo {
        public Future<String> asText(int var1);
    }
}

