/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean.issues;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.RouteDefinition;

public class FilterPojoIssueTest
extends ContextTestSupport {
    public String doSomething(String body) {
        if ("Hello World".equals(body)) {
            return "Bye World";
        }
        return null;
    }

    public void testFilterPojo() throws Exception {
        this.getMockEndpoint("mock:filter").expectedBodiesReceived(new Object[]{"Bye World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testFilterPojoNull() throws Exception {
        this.getMockEndpoint("mock:filter").expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"Foo");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ExpressionNode)((RouteDefinition)((RouteDefinition)this.from("direct:start").bean(FilterPojoIssueTest.class, "doSomething")).to("log:foo")).filter(this.body().isNotNull()).to("mock:filter")).end();
            }
        };
    }
}

