/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.controlbus;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;

public class ControlBusLanguageSimpleStartRouteTest
extends ContextTestSupport {
    public void testControlBusStartStop() throws Exception {
        ControlBusLanguageSimpleStartRouteTest.assertEquals((String)"Stopped", (String)this.context.getRouteStatus("foo").name());
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("seda:foo", (Object)"Hello World");
        this.template.sendBody("controlbus:language:simple", (Object)"camelContext.startRoute('foo')");
        this.assertMockEndpointsSatisfied();
        this.template.sendBodyAndHeader("controlbus:language:simple", (Object)"camelContext.stopRoute(header.me)", "me", (Object)"foo");
        ControlBusLanguageSimpleStartRouteTest.assertEquals((String)"Stopped", (String)this.context.getRouteStatus("foo").name());
    }

    public void testControlBusStatus() throws Exception {
        ControlBusLanguageSimpleStartRouteTest.assertEquals((String)"Stopped", (String)this.context.getRouteStatus("foo").name());
        String status = (String)this.template.requestBody("controlbus:language:simple", (Object)"camelContext.getRouteStatus('foo')", String.class);
        ControlBusLanguageSimpleStartRouteTest.assertEquals((String)"Stopped", (String)status);
        this.context.startRoute("foo");
        status = (String)this.template.requestBody("controlbus:language:simple", (Object)"camelContext.getRouteStatus('foo')", String.class);
        ControlBusLanguageSimpleStartRouteTest.assertEquals((String)"Started", (String)status);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("seda:foo").routeId("foo").noAutoStartup().to("mock:foo");
            }
        };
    }
}

