/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.controlbus;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;

public class ControlBusStatsTest
extends ContextTestSupport {
    @Override
    protected boolean useJmx() {
        return true;
    }

    public void testControlBusRouteStat() throws Exception {
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        String xml = (String)this.template.requestBody("controlbus:route?routeId=foo&action=stats", null, String.class);
        ControlBusStatsTest.assertNotNull((Object)xml);
        ControlBusStatsTest.assertTrue((boolean)xml.contains("routeStat"));
        ControlBusStatsTest.assertTrue((boolean)xml.contains("processorStat"));
        ControlBusStatsTest.assertTrue((boolean)xml.contains("id=\"foo\""));
        ControlBusStatsTest.assertTrue((boolean)xml.contains("exchangesCompleted=\"1\""));
    }

    public void testControlBusCurrentRouteStat() throws Exception {
        this.getMockEndpoint("mock:current").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:current", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        String xml = (String)this.template.requestBody("controlbus:route?routeId=current&action=stats", null, String.class);
        ControlBusStatsTest.assertNotNull((Object)xml);
        ControlBusStatsTest.assertTrue((boolean)xml.contains("routeStat"));
        ControlBusStatsTest.assertTrue((boolean)xml.contains("processorStat"));
        ControlBusStatsTest.assertTrue((boolean)xml.contains("id=\"current\""));
        ControlBusStatsTest.assertTrue((boolean)xml.contains("exchangesCompleted=\"1\""));
    }

    public void testControlBusContextStat() throws Exception {
        this.getMockEndpoint("mock:bar").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:bar", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        String xml = (String)this.template.requestBody("controlbus:route?action=stats", null, String.class);
        ControlBusStatsTest.assertNotNull((Object)xml);
        ControlBusStatsTest.assertTrue((boolean)xml.contains("camelContextStat"));
        ControlBusStatsTest.assertTrue((boolean)xml.contains("routeStat"));
        ControlBusStatsTest.assertTrue((boolean)xml.contains("processorStat"));
        ControlBusStatsTest.assertTrue((boolean)xml.contains("id=\"bar\""));
        ControlBusStatsTest.assertTrue((boolean)xml.contains("id=\"foo\""));
        ControlBusStatsTest.assertTrue((boolean)xml.contains("exchangesCompleted=\"1\""));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:foo").routeId("foo").to("mock:foo");
                this.from("direct:bar").routeId("bar").to("mock:bar");
                this.from("direct:current").routeId("current").to("mock:current");
            }
        };
    }
}

