/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dataset;

import javax.naming.Context;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.builder.PredicateBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.xml.XPathBuilder;
import org.apache.camel.component.dataset.DataSet;
import org.apache.camel.component.dataset.DataSetEndpoint;
import org.apache.camel.component.dataset.DataSetSupport;
import org.apache.camel.util.PredicateAssertHelper;

public class CustomDataSetTest
extends ContextTestSupport {
    protected DataSet dataSet = new DataSetSupport(){
        Expression expression = new XPathBuilder("/message/@index").resultType(Long.class);

        public void assertMessageExpected(DataSetEndpoint dataSetEndpoint, Exchange expected, Exchange actual, long index) throws Exception {
            Predicate predicate = PredicateBuilder.isEqualTo((Expression)this.expression, (Expression)ExpressionBuilder.constantExpression((Object)index));
            CustomDataSetTest.this.log.debug("evaluating predicate: " + predicate);
            PredicateAssertHelper.assertMatches((Predicate)predicate, (String)("Actual: " + actual), (Exchange)actual);
        }

        protected Object createMessageBody(long messageIndex) {
            return "<message index='" + messageIndex + "'>someBody" + messageIndex + "</message>";
        }
    };

    public void testUsingCustomDataSet() throws Exception {
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected Context createJndiContext() throws Exception {
        Context context = super.createJndiContext();
        context.bind("foo", (Object)this.dataSet);
        return context;
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("dataset:foo").to("direct:foo");
                this.from("direct:foo").to("dataset:foo");
            }
        };
    }
}

