/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dataset;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.dataset.DataSet;
import org.apache.camel.component.dataset.DataSetEndpoint;
import org.apache.camel.component.dataset.DataSetSupport;
import org.apache.camel.component.dataset.SimpleDataSet;

public class DataSetEndpointTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    public void testDataSetEndpoint() throws Exception {
        final DataSetEndpoint endpoint = new DataSetEndpoint();
        endpoint.setCamelContext((CamelContext)this.context);
        endpoint.setEndpointUriIfNotSpecified("dataset://foo");
        endpoint.setDataSet((DataSet)new SimpleDataSet(2));
        DataSetEndpointTest.assertEquals((long)0L, (long)endpoint.getPreloadSize());
        DataSetEndpointTest.assertEquals((long)0L, (long)endpoint.getConsumeDelay());
        DataSetEndpointTest.assertEquals((long)3L, (long)endpoint.getProduceDelay());
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from((Endpoint)endpoint).to("direct:foo");
                this.from("direct:foo").to((Endpoint)endpoint);
            }
        });
        this.context.start();
        endpoint.assertIsSatisfied();
    }

    public void testDataSetEndpointCtr() throws Exception {
        final DataSetEndpoint endpoint = new DataSetEndpoint("dataset://foo", this.context.getComponent("dataset"), (DataSet)new SimpleDataSet(2));
        endpoint.setConsumeDelay(2L);
        DataSetEndpointTest.assertEquals((long)2L, (long)endpoint.getConsumeDelay());
        endpoint.setProduceDelay(5L);
        DataSetEndpointTest.assertEquals((long)5L, (long)endpoint.getProduceDelay());
        endpoint.setInitialDelay(50L);
        DataSetEndpointTest.assertEquals((long)50L, (long)endpoint.getInitialDelay());
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from((Endpoint)endpoint).to("direct:foo");
                this.from("direct:foo").to((Endpoint)endpoint);
            }
        });
        this.context.start();
        endpoint.assertIsSatisfied();
    }

    public void testDataSetReporter() throws Exception {
        final DataSetEndpoint endpoint = new DataSetEndpoint("dataset://foo", this.context.getComponent("dataset"), (DataSet)new SimpleDataSet(10));
        final AtomicBoolean reported = new AtomicBoolean(false);
        endpoint.setReporter(new Processor(){

            public void process(Exchange exchange) throws Exception {
                reported.set(true);
            }
        });
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from((Endpoint)endpoint).to("direct:foo");
                this.from("direct:foo").to((Endpoint)endpoint);
            }
        });
        this.context.start();
        endpoint.assertIsSatisfied();
        DataSetEndpointTest.assertTrue((boolean)reported.get());
    }

    public void testSimpleDataSet() throws Exception {
        SimpleDataSet ds = new SimpleDataSet();
        ds.setSize(2L);
        ds.setDefaultBody((Object)"Hi");
        DataSetEndpointTest.assertEquals((Object)"Hi", (Object)ds.getDefaultBody());
    }

    public void testDataSetSupport() throws Exception {
        MyDataSet ds = new MyDataSet();
        ds.setSize(4L);
        ds.setReportCount(0L);
        ds.setOutputTransformer(new Processor(){

            public void process(Exchange exchange) throws Exception {
                String body = "Hi " + (String)exchange.getIn().getBody(String.class);
                exchange.getIn().setBody((Object)body);
            }
        });
        DataSetEndpointTest.assertNotNull((Object)ds.getOutputTransformer());
        final DataSetEndpoint endpoint = new DataSetEndpoint("dataset://foo", this.context.getComponent("dataset"), (DataSet)ds);
        ((ValueBuilder)endpoint.allMessages().body()).startsWith((Object)"Hi ");
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from((Endpoint)endpoint).to("direct:foo");
                this.from("direct:foo").to((Endpoint)endpoint);
            }
        });
        this.context.start();
        endpoint.assertIsSatisfied();
    }

    private static class MyDataSet
    extends DataSetSupport {
        private MyDataSet() {
        }

        protected Object createMessageBody(long messageIndex) {
            return "Message " + messageIndex;
        }
    }
}

