/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dataset;

import javax.naming.Context;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.dataset.FileDataSet;

public class FileDataSetProducerTest
extends ContextTestSupport {
    protected FileDataSet dataSet;
    final String testDataFileName = "src/test/data/file-dataset-test.txt";
    final String testPayload = String.format("Line 1%nLine 2%nLine 3%nLine 4%nLine 5%nLine 6%nLine 7%nLine 8%nLine 9%nLine 10%n", new Object[0]);
    final String sourceUri = "direct://source";
    final String dataSetName = "foo";
    final String dataSetUri = "dataset://foo";

    public void testDefaultListDataSet() throws Exception {
        this.template.sendBodyAndHeader("direct://source", (Object)this.testPayload, "CamelDataSetIndex", (Object)0);
        this.assertMockEndpointsSatisfied();
    }

    public void testDefaultListDataSetWithSizeGreaterThanListSize() throws Exception {
        int messageCount = 20;
        this.dataSet.setSize((long)messageCount);
        this.getMockEndpoint("dataset://foo").expectedMessageCount(messageCount);
        for (int i = 0; i < messageCount; ++i) {
            this.template.sendBodyAndHeader("direct://source", (Object)this.testPayload, "CamelDataSetIndex", (Object)i);
        }
        this.assertMockEndpointsSatisfied();
    }

    @Override
    public void setUp() throws Exception {
        this.dataSet = new FileDataSet("src/test/data/file-dataset-test.txt");
        FileDataSetProducerTest.assertEquals((String)"Unexpected DataSet size", (long)1L, (long)this.dataSet.getSize());
        super.setUp();
    }

    @Override
    protected Context createJndiContext() throws Exception {
        Context context = super.createJndiContext();
        context.bind("foo", (Object)this.dataSet);
        return context;
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct://source").to("dataset://foo");
            }
        };
    }
}

