/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dataset;

import java.util.LinkedList;
import javax.naming.Context;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.dataset.ListDataSet;
import org.apache.camel.component.mock.MockEndpoint;

public class ListDataSetConsumerTest
extends ContextTestSupport {
    protected ListDataSet dataSet;
    final String resultUri = "mock://result";
    final String dataSetName = "foo";
    final String dataSetUri = "dataset://foo";

    public void testDefaultListDataSet() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock://result");
        result.expectedMinimumMessageCount((int)this.dataSet.getSize());
        result.assertIsSatisfied();
    }

    public void testDefaultListDataSetWithSizeGreaterThanListSize() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock://result");
        this.dataSet.setSize(10L);
        result.expectedMinimumMessageCount((int)this.dataSet.getSize());
        result.assertIsSatisfied();
    }

    @Override
    public void setUp() throws Exception {
        LinkedList<String> bodies = new LinkedList<String>();
        bodies.add("<hello>world!</hello>");
        this.dataSet = new ListDataSet(bodies);
        super.setUp();
    }

    @Override
    protected Context createJndiContext() throws Exception {
        Context context = super.createJndiContext();
        context.bind("foo", (Object)this.dataSet);
        return context;
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("dataset://foo").to("mock://result");
            }
        };
    }
}

