/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.direct;

import org.apache.camel.ComponentConfiguration;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.EndpointConfiguration;
import org.apache.camel.component.direct.DirectComponent;
import org.apache.camel.impl.DefaultCamelContext;
import org.junit.Test;

public class DirectComponentConfigurationAndDocumentationTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testComponentConfiguration() throws Exception {
        DirectComponent comp = (DirectComponent)this.context.getComponent("direct", DirectComponent.class);
        EndpointConfiguration conf = comp.createConfiguration("direct:foo?block=true");
        DirectComponentConfigurationAndDocumentationTest.assertEquals((Object)"true", (Object)conf.getParameter("block"));
        ComponentConfiguration compConf = comp.createComponentConfiguration();
        String json = compConf.createParameterJsonSchema();
        DirectComponentConfigurationAndDocumentationTest.assertNotNull((Object)json);
        DirectComponentConfigurationAndDocumentationTest.assertTrue((boolean)json.contains("\"name\": { \"kind\": \"path\", \"group\": \"common\", \"required\": \"true\", \"type\": \"string\""));
        DirectComponentConfigurationAndDocumentationTest.assertTrue((boolean)json.contains("\"timeout\": { \"kind\": \"parameter\", \"group\": \"producer\", \"label\": \"producer\", \"type\": \"integer\""));
    }

    @Test
    public void testComponentDocumentation() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        String html = context.getComponentDocumentation("direct");
        DirectComponentConfigurationAndDocumentationTest.assertNotNull((String)"Should have found some auto-generated HTML", (Object)html);
    }

    @Test
    public void testComponentJsonSchema() throws Exception {
        DefaultCamelContext context = new DefaultCamelContext();
        String json = context.getComponentParameterJsonSchema("direct");
        DirectComponentConfigurationAndDocumentationTest.assertNotNull((String)"Should have found some auto-generated JSON", (Object)json);
    }
}

