/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.direct;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.direct.DirectEndpoint;
import org.apache.camel.component.mock.MockEndpoint;

public class DirectEndpointTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    public void testDirectEndpoint() throws Exception {
        final DirectEndpoint de = new DirectEndpoint();
        de.setCamelContext((CamelContext)this.context);
        de.setEndpointUriIfNotSpecified("direct://foo");
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from((Endpoint)de).to("mock:result");
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.sendBody((Endpoint)de, (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testDirectEndpointAgain() throws Exception {
        final DirectEndpoint de = new DirectEndpoint("direct://foo", this.context.getComponent("direct"));
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from((Endpoint)de).to("mock:result");
            }
        });
        this.context.start();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.sendBody((Endpoint)de, (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }
}

