/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.directvm;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.directvm.DirectVmConsumerExpression;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.util.ServiceHelper;
import org.junit.After;
import org.junit.Before;

public class DirectVmConsumerExpressionTest
extends ContextTestSupport {
    private CamelContext context2;
    private CamelContext context3;
    private CamelContext context4;

    @Override
    @Before
    protected void setUp() throws Exception {
        super.setUp();
        this.context2 = new DefaultCamelContext();
        this.context3 = new DefaultCamelContext();
        this.context4 = new DefaultCamelContext();
        ServiceHelper.startServices((Object[])new Object[]{this.context2});
        ServiceHelper.startServices((Object[])new Object[]{this.context3});
        ServiceHelper.startServices((Object[])new Object[]{this.context4});
        RouteBuilder routeBuilder = this.createRouteBuilderCamelContext2();
        if (routeBuilder != null) {
            this.context2.addRoutes((RoutesBuilder)routeBuilder);
        }
        if ((routeBuilder = this.createRouteBuilderCamelContext3()) != null) {
            this.context3.addRoutes((RoutesBuilder)routeBuilder);
        }
        if ((routeBuilder = this.createRouteBuilderCamelContext4()) != null) {
            this.context4.addRoutes((RoutesBuilder)routeBuilder);
        }
    }

    @Override
    @After
    protected void tearDown() throws Exception {
        ServiceHelper.stopServices((Object[])new Object[]{this.context2, this.context3, this.context4});
        super.tearDown();
    }

    public void testSelectEndpoint() throws Exception {
        MockEndpoint result2 = (MockEndpoint)this.context2.getEndpoint("mock:result2", MockEndpoint.class);
        result2.expectedBodiesReceived(new Object[]{"Hello World"});
        MockEndpoint result3 = (MockEndpoint)this.context3.getEndpoint("mock:result3", MockEndpoint.class);
        result3.expectedBodiesReceived(new Object[]{"Hello World"});
        MockEndpoint result4 = (MockEndpoint)this.context4.getEndpoint("mock:result4", MockEndpoint.class);
        result4.expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"Hello World");
        MockEndpoint.assertIsSatisfied((CamelContext)this.context2);
        MockEndpoint.assertIsSatisfied((CamelContext)this.context3);
        MockEndpoint.assertIsSatisfied((CamelContext)this.context4);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").recipientList((Expression)new DirectVmConsumerExpression("direct-vm://parent/**/context*"));
            }
        };
    }

    private RouteBuilder createRouteBuilderCamelContext2() {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct-vm:parent/child/context2").to("mock:result2");
            }
        };
    }

    private RouteBuilder createRouteBuilderCamelContext3() {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct-vm:parent/child/grandchild/context3").to("mock:result3");
            }
        };
    }

    private RouteBuilder createRouteBuilderCamelContext4() {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct-vm:parent/child/ctx4").to("mock:result4");
            }
        };
    }
}

