/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.directvm;

import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.directvm.DirectVmConsumerNotAvailableException;
import org.apache.camel.model.RouteDefinition;
import org.junit.Test;

public class DirectVmNoConsumerTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    public void testInOnly() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct-vm:start").to("direct-vm:foo");
            }
        });
        this.context.start();
        try {
            this.template.sendBody("direct-vm:start", (Object)"Hello World");
            DirectVmNoConsumerTest.fail((String)"Should throw an exception");
        }
        catch (CamelExecutionException e) {
            DirectVmNoConsumerTest.assertIsInstanceOf(DirectVmConsumerNotAvailableException.class, e.getCause());
        }
    }

    public void testInOut() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct-vm:start").to("direct-vm:foo");
            }
        });
        this.context.start();
        try {
            this.template.requestBody("direct-vm:start", (Object)"Hello World");
            DirectVmNoConsumerTest.fail((String)"Should throw an exception");
        }
        catch (CamelExecutionException e) {
            DirectVmNoConsumerTest.assertIsInstanceOf(DirectVmConsumerNotAvailableException.class, e.getCause());
        }
    }

    @Test
    public void testFailIfNoConsumerFalse() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct-vm:start").to("direct-vm:foo?failIfNoConsumers=false");
            }
        });
        this.context.start();
        try {
            this.template.sendBody("direct-vm:start", (Object)"Hello World");
        }
        catch (CamelExecutionException e) {
            DirectVmNoConsumerTest.fail((String)"Should not throw an exception");
        }
    }

    @Test
    public void testFailIfNoConsumersAfterConsumersLeave() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct-vm:foo").routeId("stopThisRoute").to("mock:foo");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct-vm:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        this.context.stopRoute("stopThisRoute");
        TimeUnit.MILLISECONDS.sleep(100L);
        try {
            this.template.sendBody("direct-vm:foo", (Object)"Hello World");
            DirectVmNoConsumerTest.fail((String)"Should throw an exception");
        }
        catch (CamelExecutionException e) {
            DirectVmNoConsumerTest.assertIsInstanceOf(DirectVmConsumerNotAvailableException.class, e.getCause());
        }
    }

    @Test
    public void testFailIfNoConsumersWithValidConsumer() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct-vm:in").to("direct-vm:foo");
                this.from("direct-vm:foo").to("mock:foo");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct-vm:in", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testFailIfNoConsumersFalseWithPipeline() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct-vm:in").to("direct-vm:foo?failIfNoConsumers=false")).to("direct-vm:bar");
                this.from("direct-vm:bar").to("mock:foo");
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct-vm:in", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testConfigOnAConsumer() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct-vm:foo?failIfNoConsumers=false").to("log:test");
            }
        });
        this.context.start();
    }
}

