/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.directvm;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.directvm.DirectVmConsumerNotAvailableException;
import org.apache.camel.component.directvm.DirectVmEndpoint;
import org.apache.camel.util.StopWatch;

public class DirectVmProducerBlockingTest
extends ContextTestSupport {
    public void testProducerBlocksForSuspendedConsumer() throws Exception {
        DirectVmEndpoint endpoint = this.getMandatoryEndpoint("direct-vm:suspended", DirectVmEndpoint.class);
        endpoint.getConsumer().suspend();
        StopWatch watch = new StopWatch();
        try {
            this.template.sendBody("direct-vm:suspended?block=true&timeout=2000", (Object)"hello world");
            DirectVmProducerBlockingTest.fail((String)"Expected CamelExecutionException");
        }
        catch (CamelExecutionException e) {
            DirectVmConsumerNotAvailableException cause = DirectVmProducerBlockingTest.assertIsInstanceOf(DirectVmConsumerNotAvailableException.class, e.getCause());
            DirectVmProducerBlockingTest.assertIsInstanceOf(CamelExchangeException.class, cause);
            DirectVmProducerBlockingTest.assertTrue((watch.taken() > 1500L ? 1 : 0) != 0);
        }
    }

    public void testProducerBlocksWithNoConsumers() throws Exception {
        DirectVmEndpoint endpoint = this.getMandatoryEndpoint("direct-vm:suspended", DirectVmEndpoint.class);
        endpoint.getConsumer().suspend();
        StopWatch watch = new StopWatch();
        try {
            this.template.sendBody("direct-vm:start?block=true&timeout=2000", (Object)"hello world");
            DirectVmProducerBlockingTest.fail((String)"Expected CamelExecutionException");
        }
        catch (CamelExecutionException e) {
            DirectVmConsumerNotAvailableException cause = DirectVmProducerBlockingTest.assertIsInstanceOf(DirectVmConsumerNotAvailableException.class, e.getCause());
            DirectVmProducerBlockingTest.assertIsInstanceOf(CamelExchangeException.class, cause);
            DirectVmProducerBlockingTest.assertTrue((watch.taken() > 1500L ? 1 : 0) != 0);
        }
    }

    public void testProducerBlocksResumeTest() throws Exception {
        this.context.suspendRoute("foo");
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(2000L);
                    DirectVmProducerBlockingTest.this.log.info("Resuming consumer");
                    DirectVmProducerBlockingTest.this.context.resumeRoute("foo");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct-vm:suspended?block=true&timeout=5000", (Object)"hello world");
        this.assertMockEndpointsSatisfied();
        executor.shutdownNow();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct-vm:suspended").routeId("foo").to("mock:result");
            }
        };
    }
}

