/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import java.io.IOException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.component.file.FileConsumer;
import org.apache.camel.component.file.FileEndpoint;
import org.apache.camel.component.file.GenericFile;

public class FileConfigureTest
extends ContextTestSupport {
    private static final String EXPECT_PATH = "target" + File.separator + "foo" + File.separator + "bar";
    private static final String EXPECT_FILE = "some" + File.separator + "nested" + File.separator + "filename.txt";
    private static final Processor DUMMY_PROCESSOR = new Processor(){

        public void process(Exchange exchange) throws Exception {
        }
    };

    public void testUriConfigurations() throws Exception {
        this.assertFileEndpoint("file://target/foo/bar", EXPECT_PATH, false);
        this.assertFileEndpoint("file://target/foo/bar?delete=true", EXPECT_PATH, false);
        this.assertFileEndpoint("file:target/foo/bar?delete=true", EXPECT_PATH, false);
        this.assertFileEndpoint("file:target/foo/bar", EXPECT_PATH, false);
        this.assertFileEndpoint("file://target/foo/bar/", EXPECT_PATH, false);
        this.assertFileEndpoint("file://target/foo/bar/?delete=true", EXPECT_PATH, false);
        this.assertFileEndpoint("file:target/foo/bar/?delete=true", EXPECT_PATH, false);
        this.assertFileEndpoint("file:target/foo/bar/", EXPECT_PATH, false);
        this.assertFileEndpoint("file:/target/foo/bar/", File.separator + EXPECT_PATH + File.separator + EXPECT_FILE, true);
        this.assertFileEndpoint("file:/", File.separator, true);
        this.assertFileEndpoint("file:///", File.separator, true);
    }

    public void testUriWithParameters() throws Exception {
        FileEndpoint endpoint = this.resolveMandatoryEndpoint("file:///C:/camel/temp?delay=10&useFixedDelay=true&initialDelay=10&consumer.bridgeErrorHandler=true&autoCreate=false&startingDirectoryMustExist=true&directoryMustExist=true&readLock=changed", FileEndpoint.class);
        FileConfigureTest.assertNotNull((String)"Could not find file endpoint", (Object)endpoint);
        FileConfigureTest.assertEquals((String)"Get a wrong option of StartingDirectoryMustExist", (boolean)true, (boolean)endpoint.isStartingDirectoryMustExist());
        endpoint = this.resolveMandatoryEndpoint("file:///C:/camel/temp?delay=10&useFixedDelay=true&initialDelay=10&startingDirectoryMustExist=true&consumer.bridgeErrorHandler=true&autoCreate=false&directoryMustExist=true&readLock=changed", FileEndpoint.class);
        FileConfigureTest.assertNotNull((String)"Could not find file endpoint", (Object)endpoint);
        FileConfigureTest.assertEquals((String)"Get a wrong option of StartingDirectoryMustExist", (boolean)true, (boolean)endpoint.isStartingDirectoryMustExist());
        endpoint = this.resolveMandatoryEndpoint("file:///C:/camel/temp?delay=10&startingDirectoryMustExist=true&useFixedDelay=true&initialDelay=10&consumer.bridgeErrorHandler=true&autoCreate=false&directoryMustExist=true&readLock=changed", FileEndpoint.class);
        FileConfigureTest.assertNotNull((String)"Could not find file endpoint", (Object)endpoint);
        FileConfigureTest.assertEquals((String)"Get a wrong option of StartingDirectoryMustExist", (boolean)true, (boolean)endpoint.isStartingDirectoryMustExist());
        endpoint = this.resolveMandatoryEndpoint("file:///C:/camel/temp?delay=10&useFixedDelay=true&initialDelay=10", FileEndpoint.class);
        FileConfigureTest.assertNotNull((String)"Could not find file endpoint", (Object)endpoint);
        FileConfigureTest.assertEquals((String)"Get a wrong option of StartingDirectoryMustExist", (boolean)false, (boolean)endpoint.isStartingDirectoryMustExist());
    }

    public void testUriWithCharset() throws Exception {
        FileEndpoint endpoint = this.resolveMandatoryEndpoint("file://target/foo/bar?charset=UTF-8", FileEndpoint.class);
        FileConfigureTest.assertNotNull((String)"Could not find endpoint: file://target/foo/bar?charset=UTF-8", (Object)endpoint);
        FileConfigureTest.assertEquals((String)"Get a wrong charset", (String)"UTF-8", (String)endpoint.getCharset());
        try {
            this.resolveMandatoryEndpoint("file://target/foo/bar?charset=ASSI", FileEndpoint.class);
            FileConfigureTest.fail((String)"Expect a configure exception here");
        }
        catch (Exception ex) {
            FileConfigureTest.assertTrue((String)"Get the wrong exception type here", (boolean)(ex instanceof ResolveEndpointFailedException));
        }
    }

    public void testConsumerConfigurations() throws Exception {
        FileConsumer consumer = this.createFileConsumer("file://target/foo/bar?recursive=true");
        FileConfigureTest.assertNotNull((Object)consumer);
        try {
            this.createFileConsumer("file://target/foo/bar?recursiv=true");
            FileConfigureTest.fail((String)"Expect a configure exception here");
        }
        catch (Exception ex) {
            FileConfigureTest.assertTrue((String)"Get the wrong exception type here", (boolean)(ex instanceof ResolveEndpointFailedException));
        }
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        FileConfigureTest.deleteDirectory("/target");
    }

    private FileConsumer createFileConsumer(String endpointUri) throws Exception {
        FileEndpoint endpoint = this.resolveMandatoryEndpoint(endpointUri, FileEndpoint.class);
        return endpoint.createConsumer(DUMMY_PROCESSOR);
    }

    private void assertFileEndpoint(String endpointUri, String expectedPath, boolean absolute) throws IOException {
        FileEndpoint endpoint = this.resolveMandatoryEndpoint(endpointUri, FileEndpoint.class);
        FileConfigureTest.assertNotNull((String)("Could not find endpoint: " + endpointUri), (Object)endpoint);
        if (!absolute) {
            File file = endpoint.getFile();
            String path = file.getPath();
            FileConfigureTest.assertDirectoryEquals("For uri: " + endpointUri + " the file is not equal", expectedPath, path);
            file = new File(expectedPath + (expectedPath.endsWith(File.separator) ? "" : File.separator) + EXPECT_FILE);
            GenericFile consumedFile = FileConsumer.asGenericFile((String)endpoint.getFile().getPath(), (File)file, null, (boolean)false);
            FileConfigureTest.assertEquals((String)EXPECT_FILE, (String)consumedFile.getRelativeFilePath());
        }
    }
}

