/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import junit.framework.TestCase;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class FileConsumerBeginAndCommitRenameStrategyTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        FileConsumerBeginAndCommitRenameStrategyTest.deleteDirectory("target/inprogress");
        FileConsumerBeginAndCommitRenameStrategyTest.deleteDirectory("target/done");
        FileConsumerBeginAndCommitRenameStrategyTest.deleteDirectory("target/reports");
        super.setUp();
    }

    public void testRenameSuccess() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:report");
        mock.expectedMessageCount(1);
        mock.expectedBodiesReceived(new Object[]{"Hello Paris"});
        mock.expectedFileExists("target/done/paris.txt", "Hello Paris");
        this.template.sendBodyAndHeader("file:target/reports", (Object)"Hello Paris", "CamelFileName", (Object)"paris.txt");
        mock.assertIsSatisfied();
    }

    public void testIllegalOptions() throws Exception {
        try {
            this.context.getEndpoint("file://target?move=../done/${file:name}&delete=true").createConsumer(new Processor(){

                public void process(Exchange exchange) throws Exception {
                }
            });
            FileConsumerBeginAndCommitRenameStrategyTest.fail((String)"Should have thrown an exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.context.getEndpoint("file://target?move=${file:name.noext}.bak&delete=true").createConsumer(new Processor(){

                public void process(Exchange exchange) throws Exception {
                }
            });
            FileConsumerBeginAndCommitRenameStrategyTest.fail((String)"Should have thrown an exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("file://target/reports?preMove=../inprogress/${file:name}&move=../done/${file:name}&delay=5000").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        GenericFile file = (GenericFile)exchange.getProperty("CamelFileExchangeFile");
                        TestCase.assertNotNull((Object)file);
                        TestCase.assertTrue((file.getRelativeFilePath().indexOf("inprogress") > -1 ? 1 : 0) != 0);
                    }
                })).to("mock:report");
            }
        };
    }
}

