/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.mock.MockEndpoint;

public class FileConsumerConsumedFileNameTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        FileConsumerConsumedFileNameTest.deleteDirectory("target/consumedfilename");
        super.setUp();
        this.template.sendBodyAndHeader("file:target/consumedfilename", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
    }

    public void testValidFilenameOnExchange() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        ((ValueBuilder)mock.message(0).header("CamelFileName")).isEqualTo((Object)"hello.txt");
        ((ValueBuilder)mock.message(0).header("CamelFileNameConsumed")).isEqualTo((Object)"hello.txt");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("file:target/consumedfilename").to("mock:result");
            }
        };
    }
}

