/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class FileConsumerExcludeNameTest
extends ContextTestSupport {
    public void testExludePreAndPostfixes() throws Exception {
        FileConsumerExcludeNameTest.deleteDirectory("target/exclude");
        this.prepareFiles();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceivedInAnyOrder(new Object[]{"Reports1", "Reports2", "Reports3"});
        mock.expectedMessageCount(3);
        mock.assertIsSatisfied();
    }

    private void prepareFiles() throws Exception {
        String url = "file://target/exclude";
        this.template.sendBodyAndHeader(url, (Object)"Hello World", "CamelFileName", (Object)"hello.xml");
        this.template.sendBodyAndHeader(url, (Object)"Reports1", "CamelFileName", (Object)"report1.txt");
        this.template.sendBodyAndHeader(url, (Object)"Bye World", "CamelFileName", (Object)"secret.txt");
        this.template.sendBodyAndHeader(url, (Object)"Reports2", "CamelFileName", (Object)"report2.txt");
        this.template.sendBodyAndHeader(url, (Object)"Reports3", "CamelFileName", (Object)"Report3.txt");
        this.template.sendBodyAndHeader(url, (Object)"Secret2", "CamelFileName", (Object)"Secret2.txt");
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("file://target/exclude/?exclude=^secret.*|.*xml$").convertBodyTo(String.class)).to("mock:result");
            }
        };
    }
}

