/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.util.FileUtil;
import org.junit.Test;

public class FileConsumerExtendedAttributesTest
extends ContextTestSupport {
    private static final String ROOT = "target/extended-attributes";
    private static final String FILE = "attributes.txt";

    @Override
    protected void setUp() throws Exception {
        FileConsumerExtendedAttributesTest.deleteDirectory(ROOT);
        super.setUp();
        Files.createFile(Paths.get(ROOT, "basic", FILE), new FileAttribute[0]);
        Files.createFile(Paths.get(ROOT, "basic-as-default", FILE), new FileAttribute[0]);
        Files.createFile(Paths.get(ROOT, "basic-as-default-with-filter", FILE), new FileAttribute[0]);
        Files.createFile(Paths.get(ROOT, "posix", FILE), new FileAttribute[0]);
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.fromF("file://%s/basic?extendedAttributes=basic:*", new Object[]{FileConsumerExtendedAttributesTest.ROOT}).convertBodyTo(String.class)).to("mock:basic");
                ((RouteDefinition)this.fromF("file://%s/basic-as-default?extendedAttributes=*", new Object[]{FileConsumerExtendedAttributesTest.ROOT}).convertBodyTo(String.class)).to("mock:basic-as-default");
                ((RouteDefinition)this.fromF("file://%s/basic-as-default-with-filter?extendedAttributes=size,lastModifiedTime,lastAccessTime", new Object[]{FileConsumerExtendedAttributesTest.ROOT}).convertBodyTo(String.class)).to("mock:basic-as-default-with-filter");
                ((RouteDefinition)this.fromF("file://%s/posix?extendedAttributes=posix:*", new Object[]{FileConsumerExtendedAttributesTest.ROOT}).convertBodyTo(String.class)).to("mock:posix");
            }
        };
    }

    @Test
    public void testBasicAttributes() throws Exception {
        this.testAttributes("mock:basic", "basic:");
    }

    @Test
    public void testBasicAttributesAsDefault() throws Exception {
        this.testAttributes("mock:basic-as-default", "basic:");
    }

    @Test
    public void testBasicAttributesAsDefaultWithFilter() throws Exception {
        this.testAttributes("mock:basic-as-default", "basic:");
    }

    @Test
    public void testPosixAttributes() throws Exception {
        if (FileUtil.isWindows()) {
            return;
        }
        this.testAttributes("mock:posix", "posix:");
    }

    private void testAttributes(String mockEndpoint, String prefix) throws Exception {
        MockEndpoint mock = this.getMockEndpoint(mockEndpoint);
        mock.expectedMessageCount(1);
        ((ValueBuilder)mock.message(0).header("CamelFileExtendedAttributes")).isNotNull();
        ((ValueBuilder)mock.message(0).header("CamelFileExtendedAttributes")).convertTo(Map.class);
        this.assertMockEndpointsSatisfied();
        Map attributes = (Map)((Exchange)mock.getExchanges().get(0)).getIn().getHeader("CamelFileExtendedAttributes", Map.class);
        FileConsumerExtendedAttributesTest.assertNotNull((Object)attributes);
        FileConsumerExtendedAttributesTest.assertFalse((boolean)attributes.isEmpty());
        for (Map.Entry entry : attributes.entrySet()) {
            FileConsumerExtendedAttributesTest.assertTrue((boolean)((String)entry.getKey()).startsWith(prefix));
        }
    }
}

