/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import junit.framework.TestCase;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.IdempotentRepository;

public class FileConsumerIdempotentRefTest
extends ContextTestSupport {
    private static volatile boolean invoked;

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("myRepo", (Object)new MyIdempotentRepository());
        return jndi;
    }

    @Override
    protected void setUp() throws Exception {
        FileConsumerIdempotentRefTest.deleteDirectory("target/idempotent");
        super.setUp();
        this.template.sendBodyAndHeader("file://target/idempotent/", (Object)"Hello World", "CamelFileName", (Object)"report.txt");
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("file://target/idempotent/?idempotent=true&idempotentRepository=#myRepo&move=done/${file:name}&delay=10").convertBodyTo(String.class)).to("mock:result");
            }
        };
    }

    public void testIdempotentRef() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        mock.expectedMessageCount(1);
        this.assertMockEndpointsSatisfied();
        this.oneExchangeDone.matchesMockWaitTime();
        mock.reset();
        mock.expectedMessageCount(0);
        File file = new File("target/idempotent/done/report.txt");
        File renamed = new File("target/idempotent/report.txt");
        file.renameTo(renamed);
        Thread.sleep(100L);
        this.assertMockEndpointsSatisfied();
        FileConsumerIdempotentRefTest.assertTrue((String)"MyIdempotentRepository should have been invoked", (boolean)invoked);
    }

    public class MyIdempotentRepository
    implements IdempotentRepository<String> {
        public boolean add(String messageId) {
            boolean result = invoked;
            invoked = true;
            TestCase.assertEquals((String)"report.txt", (String)messageId);
            return !result;
        }

        public boolean contains(String key) {
            return invoked;
        }

        public boolean remove(String key) {
            return true;
        }

        public boolean confirm(String key) {
            return true;
        }

        public void clear() {
        }

        public void start() throws Exception {
        }

        public void stop() throws Exception {
        }
    }
}

