/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Predicate;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.InterceptDefinition;
import org.apache.camel.model.RouteDefinition;

public class FileConsumerInterceptEmptyFileTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        FileConsumerInterceptEmptyFileTest.deleteDirectory("target/exclude");
        super.setUp();
    }

    public void testExcludeZeroLengthFiles() throws Exception {
        MockEndpoint mock1 = this.getMockEndpoint("mock:result");
        mock1.expectedBodiesReceivedInAnyOrder(new Object[]{"Hello World", "Bye World"});
        MockEndpoint mock2 = this.getMockEndpoint("mock:skip");
        mock2.expectedMessageCount(2);
        this.sendFiles();
        this.assertMockEndpointsSatisfied();
    }

    private void sendFiles() throws Exception {
        String url = "file://target/exclude";
        this.template.sendBodyAndHeader(url, (Object)"Hello World", "CamelFileName", (Object)"hello.xml");
        this.template.sendBodyAndHeader(url, (Object)"", "CamelFileName", (Object)"empty1.txt");
        this.template.sendBodyAndHeader(url, (Object)"Bye World", "CamelFileName", (Object)"secret.txt");
        this.template.sendBodyAndHeader(url, (Object)"", "CamelFileName", (Object)"empty2.txt");
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((InterceptDefinition)this.interceptFrom().when((Predicate)this.simple("${file:length} == 0")).to("mock:skip")).stop();
                ((RouteDefinition)((RouteDefinition)this.from("file://target/exclude/").convertBodyTo(String.class)).to("log:test")).to("mock:result");
            }
        };
    }
}

