/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class FileConsumerPathWithAmpersandTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        FileConsumerPathWithAmpersandTest.deleteDirectory("target/file&stuff");
        super.setUp();
    }

    public void testPathWithAmpersand() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.sendBodyAndHeader("file://target/file&stuff", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("file://target/file&stuff?delete=true&initialDelay=0&delay=10").convertBodyTo(String.class)).to("mock:result");
            }
        };
    }
}

