/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import junit.framework.TestCase;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class FileConsumerPreMoveNoopTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        FileConsumerPreMoveNoopTest.deleteDirectory("target/premove");
        super.setUp();
    }

    public void testPreMoveNoop() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.sendBodyAndHeader("file://target/premove", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.assertMockEndpointsSatisfied();
        this.oneExchangeDone.matchesMockWaitTime();
        File pre = new File("target/premove/work/hello.txt");
        FileConsumerPreMoveNoopTest.assertTrue((String)"Pre move file should exist", (boolean)pre.exists());
    }

    public void testPreMoveNoopSameFileTwice() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBodyAndHeader("file://target/premove", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.assertMockEndpointsSatisfied();
        this.oneExchangeDone.matchesMockWaitTime();
        mock.reset();
        this.oneExchangeDone.reset();
        mock.expectedBodiesReceived(new Object[]{"Hello Again World"});
        this.template.sendBodyAndHeader("file://target/premove", (Object)"Hello Again World", "CamelFileName", (Object)"hello.txt");
        this.assertMockEndpointsSatisfied();
        this.oneExchangeDone.matchesMockWaitTime();
        File pre = new File("target/premove/work/hello.txt");
        FileConsumerPreMoveNoopTest.assertTrue((String)"Pre move file should exist", (boolean)pre.exists());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("file://target/premove?preMove=work&noop=true&idempotent=false&initialDelay=0&delay=10").process((Processor)new MyPreMoveCheckerProcessor())).to("mock:result");
            }
        };
    }

    public static class MyPreMoveCheckerProcessor
    implements Processor {
        public void process(Exchange exchange) throws Exception {
            File pre = new File("target/premove/work/hello.txt");
            TestCase.assertTrue((String)"Pre move file should exist", (boolean)pre.exists());
        }
    }
}

