/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.RouteDefinition;

public class FileMoveAndMoveFailedIssueTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        FileMoveAndMoveFailedIssueTest.deleteDirectory("target/input");
        super.setUp();
    }

    public void testMove() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedFileExists("target/input/target/input.bak/somedate/hello.txt");
        this.template.sendBodyAndHeader("file:target/input", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.assertMockEndpointsSatisfied();
    }

    public void testMoveFailed() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.getMockEndpoint("mock:result").expectedFileExists("target/input/target/input.err/somedate/bomb.txt");
        this.template.sendBodyAndHeader("file:target/input", (Object)"Kaboom", "CamelFileName", (Object)"bomb.txt");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((ExpressionNode)((RouteDefinition)this.from("file:./target/input?move=${file:parent}.bak/somedate/${file:onlyname}&moveFailed=${file:parent}.err/somedate/${file:onlyname}").convertBodyTo(String.class)).filter(this.body().contains((Object)"Kaboom")).throwException((Exception)new IllegalArgumentException("Forced"))).end().to("mock:result");
            }
        };
    }
}

