/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class FilePollEnrichTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        FilePollEnrichTest.deleteDirectory("target/pollenrich");
        super.setUp();
    }

    public void testFilePollEnrich() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        mock.expectedFileExists("target/pollenrich/done/hello.txt");
        this.template.sendBodyAndHeader("file:target/pollenrich", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        this.assertMockEndpointsSatisfied();
        this.oneExchangeDone.matchesMockWaitTime();
        File file = new File("target/pollenrich/hello.txt");
        FilePollEnrichTest.assertFalse((String)"File should have been moved", (boolean)file.exists());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("timer:foo?period=1000").routeId("foo").log("Trigger timer foo")).pollEnrich("file:target/pollenrich?move=done", 5000L)).convertBodyTo(String.class)).log("Polled filed ${file:name}")).to("mock:result")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        exchange.getContext().stopRoute("foo", 100L, TimeUnit.MILLISECONDS);
                    }
                });
            }
        };
    }
}

