/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.util.HashMap;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class FileProduceOverruleOnlyOnceTest
extends ContextTestSupport {
    public void testBoth() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedHeaderReceived("CamelFileName", (Object)"hello.txt");
        ((ValueBuilder)mock.message(0).header("CamelOverruleFileName")).isNull();
        mock.expectedFileExists("target/write/ruled.txt", "Hello World");
        mock.expectedFileExists("target/again/hello.txt", "Hello World");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("CamelFileName", "hello.txt");
        map.put("CamelOverruleFileName", "ruled.txt");
        this.template.sendBodyAndHeaders("direct:start", (Object)"Hello World", map);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected void setUp() throws Exception {
        FileProduceOverruleOnlyOnceTest.deleteDirectory("target/write");
        FileProduceOverruleOnlyOnceTest.deleteDirectory("target/again");
        super.setUp();
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").to("file://target/write")).to(new String[]{"file://target/again", "mock:result"});
            }
        };
    }
}

