/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class FileProducerFileExistTryRenameTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        FileProducerFileExistTryRenameTest.deleteDirectory("target/file");
        super.setUp();
        this.template.sendBodyAndHeader("file://target/file", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
    }

    public void testIgnore() throws Exception {
        if (FileProducerFileExistTryRenameTest.isPlatform("windows")) {
            return;
        }
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Bye World"});
        mock.expectedFileExists("target/file/hello.txt", "Bye World");
        this.template.sendBodyAndHeader("file://target/file?fileExist=TryRename&tempPrefix=tmp", (Object)"Bye World", "CamelFileName", (Object)"hello.txt");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("file://target/file?noop=true&delay=1000").convertBodyTo(String.class)).to("mock:result");
            }
        };
    }
}

