/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.MulticastDefinition;

public class FileProducerNoForcedWritesTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        FileProducerNoForcedWritesTest.deleteDirectory("target/file");
        super.setUp();
        this.template.sendBodyAndHeader("file://target/file", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
    }

    public void testNoForcedWrites() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.assertMockEndpointsSatisfied();
        FileProducerNoForcedWritesTest.assertFileExists("target/file/output.txt");
        FileProducerNoForcedWritesTest.assertEquals((String)"Hello World", (String)((String)this.context.getTypeConverter().convertTo(String.class, (Object)new File("target/file/output.txt"))));
        FileProducerNoForcedWritesTest.assertFileExists("target/file/output2.txt");
        FileProducerNoForcedWritesTest.assertEquals((String)"Hello World", (String)((String)this.context.getTypeConverter().convertTo(String.class, (Object)new File("target/file/output2.txt"))));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((MulticastDefinition)this.from("file:target/file?noop=true").multicast().to(new String[]{"file:target/file/?fileName=output.txt&forceWrites=false", "file:target/file/?fileName=output2.txt&charset=iso-8859-1&forceWrites=false"})).to("mock:result");
            }
        };
    }
}

