/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class FileRecursiveNoopTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        FileRecursiveNoopTest.deleteDirectory("target/noop");
        super.setUp();
    }

    public void testRecursiveNoop() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceivedInAnyOrder(new Object[]{"a", "b", "a2", "c", "b2"});
        this.template.sendBodyAndHeader("file:target/noop", (Object)"a", "CamelFileName", (Object)"a.txt");
        this.template.sendBodyAndHeader("file:target/noop", (Object)"b", "CamelFileName", (Object)"b.txt");
        this.template.sendBodyAndHeader("file:target/noop/foo", (Object)"a2", "CamelFileName", (Object)"a.txt");
        this.template.sendBodyAndHeader("file:target/noop/bar", (Object)"c", "CamelFileName", (Object)"c.txt");
        this.template.sendBodyAndHeader("file:target/noop/bar", (Object)"b2", "CamelFileName", (Object)"b.txt");
        this.assertMockEndpointsSatisfied();
        mock.reset();
        mock.expectedBodiesReceived(new Object[]{"c2"});
        this.template.sendBodyAndHeader("file:target/noop", (Object)"c2", "CamelFileName", (Object)"c.txt");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("file:target/noop?recursive=true&noop=true").convertBodyTo(String.class)).to("mock:result");
            }
        };
    }
}

