/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;

public class FileRenameFileOnCommitIssueTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        FileRenameFileOnCommitIssueTest.deleteDirectory("target/renameissue");
        super.setUp();
    }

    public void testFileRenameFileOnCommitIssue() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedFileExists("target/renameissue/.camel/hello.txt");
        this.template.sendBodyAndHeader("file://target/renameissue", (Object)"World", "CamelFileName", (Object)"hello.txt");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)((ProcessorDefinition)this.from("file://target/renameissue?noop=false").setProperty("PartitionID").simple("${file:name}")).convertBodyTo(String.class)).inOut("direct:source")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        log.info("The exchange's IN body as String is {}", exchange.getIn().getBody(String.class));
                    }
                })).to("mock:result");
                this.from("direct:source").transform((Expression)this.body().prepend((Object)"Hello "));
            }
        };
    }
}

