/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.File;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;

public class FromFileDoNotMoveFileIfProcessFailsTest
extends ContextTestSupport {
    private String body = "Hello World this file will NOT be moved";

    @Override
    protected void setUp() throws Exception {
        FromFileDoNotMoveFileIfProcessFailsTest.deleteDirectory("target/movefile");
        super.setUp();
    }

    public void testPollFileAndShouldNotBeMoved() throws Exception {
        this.template.sendBodyAndHeader("file://target/movefile", (Object)this.body, "CamelFileName", (Object)"hello.txt");
        MockEndpoint mock = this.getMockEndpoint("mock:error");
        mock.expectedMinimumMessageCount(1);
        mock.assertIsSatisfied();
        this.oneExchangeDone.matchesMockWaitTime();
        File file = new File("target/movefile/hello.txt");
        FromFileDoNotMoveFileIfProcessFailsTest.assertTrue((String)"The file should NOT have been moved", (boolean)file.exists());
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.onException(IllegalArgumentException.class).to("mock:error");
                this.from("file://target/movefile?move=done").process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        throw new IllegalArgumentException("Forced by unittest");
                    }
                });
            }
        };
    }
}

