/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class FromFileMoveFileIfProcessFailsTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        FromFileMoveFileIfProcessFailsTest.deleteDirectory("target/movefile");
        super.setUp();
    }

    public void testPollFileAndShouldNotBeMoved() throws Exception {
        this.template.sendBodyAndHeader("file://target/movefile", (Object)"Hello World", "CamelFileName", (Object)"hello.txt");
        MockEndpoint mock = this.getMockEndpoint("mock:foo");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        mock.expectedFileExists("target/movefile/error/hello.txt", "Hello World");
        mock.assertIsSatisfied();
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)((RouteDefinition)this.from("file://target/movefile?moveFailed=error").convertBodyTo(String.class)).to("mock:foo")).process(new Processor(){

                    public void process(Exchange exchange) throws Exception {
                        throw new IllegalArgumentException("Forced by unittest");
                    }
                });
            }
        };
    }
}

