/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.PipelineDefinition;

public class FromFileMulticastToFilesTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        FromFileMulticastToFilesTest.deleteDirectory("target/multicast");
        super.setUp();
    }

    public void testFromFileMulticastToFiles() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((PipelineDefinition)((PipelineDefinition)((PipelineDefinition)((PipelineDefinition)((PipelineDefinition)((PipelineDefinition)this.from("file://target/multicast").multicast().pipeline().transform((Expression)this.body().prepend((Object)"HEADER:"))).to("file://target/multicast/out/?fileName=header.txt")).to("mock:header")).end().pipeline().transform((Expression)this.body().prepend((Object)"FOOTER:"))).to("file://target/multicast/out/?fileName=footer.txt")).to("mock:footer")).end().end().to("mock:end");
            }
        });
        this.context.start();
        MockEndpoint header = this.getMockEndpoint("mock:header");
        header.expectedBodiesReceived(new Object[]{"HEADER:foo"});
        header.expectedFileExists("target/multicast/out/header.txt");
        MockEndpoint footer = this.getMockEndpoint("mock:footer");
        footer.expectedBodiesReceived(new Object[]{"FOOTER:foo"});
        footer.expectedFileExists("target/multicast/out/footer.txt");
        MockEndpoint end = this.getMockEndpoint("mock:end");
        end.expectedMessageCount(1);
        end.expectedFileExists("target/multicast/.camel/foo.txt");
        this.template.sendBodyAndHeader("file://target/multicast", (Object)"foo", "CamelFileName", (Object)"foo.txt");
        this.assertMockEndpointsSatisfied();
    }

    public void testFromFileMulticastParallelToFiles() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((PipelineDefinition)((PipelineDefinition)((PipelineDefinition)((PipelineDefinition)((PipelineDefinition)((PipelineDefinition)this.from("file://target/multicast").multicast().parallelProcessing().pipeline().transform((Expression)this.body().prepend((Object)"HEADER:"))).to("file://target/multicast/out/?fileName=header.txt")).to("mock:header")).end().pipeline().transform((Expression)this.body().prepend((Object)"FOOTER:"))).to("file://target/multicast/out/?fileName=footer.txt")).to("mock:footer")).end().end().to("mock:end");
            }
        });
        this.context.start();
        MockEndpoint header = this.getMockEndpoint("mock:header");
        header.expectedBodiesReceived(new Object[]{"HEADER:foo"});
        header.expectedFileExists("target/multicast/out/header.txt");
        MockEndpoint footer = this.getMockEndpoint("mock:footer");
        footer.expectedBodiesReceived(new Object[]{"FOOTER:foo"});
        footer.expectedFileExists("target/multicast/out/footer.txt");
        MockEndpoint end = this.getMockEndpoint("mock:end");
        end.expectedMessageCount(1);
        end.expectedFileExists("target/multicast/.camel/foo.txt");
        this.template.sendBodyAndHeader("file://target/multicast", (Object)"foo", "CamelFileName", (Object)"foo.txt");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }
}

