/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import java.io.FileOutputStream;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.NotifyBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;

public class MarkerFileExclusiveReadLockStrategyUnlockTest
extends ContextTestSupport {
    @Override
    protected void setUp() throws Exception {
        this.setupDirectory();
        super.setUp();
    }

    public void testUnlocking() throws Exception {
        NotifyBuilder notify = new NotifyBuilder((CamelContext)this.context).whenDone(1).create();
        this.writeFiles();
        boolean done = notify.matches(5L, TimeUnit.SECONDS);
        MarkerFileExclusiveReadLockStrategyUnlockTest.assertTrue((String)"Route should be done processing 1 exchanges", (boolean)done);
        MarkerFileExclusiveReadLockStrategyUnlockTest.assertFileNotExists("target/marker-unlock/input-a/file1.dat.camelLock");
        MarkerFileExclusiveReadLockStrategyUnlockTest.assertFileNotExists("target/marker-unlock/input-b/file2.dat.camelLock");
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("file:target/marker-unlock/input-a?fileName=file1.dat&readLock=markerFile").pollEnrich("file:target/marker-unlock/input-b?fileName=file2.dat&readLock=markerFile")).to("mock:result");
            }
        };
    }

    private void setupDirectory() {
        MarkerFileExclusiveReadLockStrategyUnlockTest.deleteDirectory("target/marker-unlock/");
        MarkerFileExclusiveReadLockStrategyUnlockTest.createDirectory("target/marker-unlock/input-a");
        MarkerFileExclusiveReadLockStrategyUnlockTest.createDirectory("target/marker-unlock/input-b");
    }

    private void writeFiles() throws Exception {
        FileOutputStream fos1 = new FileOutputStream("target/marker-unlock/input-a/file1.dat");
        FileOutputStream fos2 = new FileOutputStream("target/marker-unlock/input-b/file2.dat");
        fos1.write("File-1".getBytes());
        fos2.write("File-2".getBytes());
        fos1.flush();
        fos1.close();
        fos2.flush();
        fos2.close();
    }
}

