/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.RouteDefinition;

public class ToFileRouteTest
extends ContextTestSupport {
    public void testToFile() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedFileExists("target/test-reports/report.txt");
        this.template.sendBody("direct:reports", (Object)"This is a great report");
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry reg = super.createRegistry();
        reg.bind("processReport", (Object)new ProcessReport());
        return reg;
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:reports").process("processReport")).to(new String[]{"file://target/test-reports", "mock:result"});
            }
        };
    }

    private static class ProcessReport
    implements Processor {
        private ProcessReport() {
        }

        public void process(Exchange exchange) throws Exception {
            String body = (String)exchange.getIn().getBody(String.class);
            exchange.getOut().setBody((Object)body);
            exchange.getOut().setHeader("CamelFileName", (Object)"report.txt");
        }
    }
}

