/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.strategy;

import java.io.File;
import java.io.FileOutputStream;
import java.util.Date;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Predicate;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileChangedReadLockMinAgeTest
extends ContextTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(FileChangedReadLockMinAgeTest.class);

    @Override
    protected void setUp() throws Exception {
        FileChangedReadLockMinAgeTest.deleteDirectory("target/changed/");
        FileChangedReadLockMinAgeTest.createDirectory("target/changed/in");
        super.setUp();
    }

    public void testChangedReadLockMinAge() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedFileExists("target/changed/out/slowfile.dat");
        mock.expectedMessagesMatches(new Predicate[]{FileChangedReadLockMinAgeTest.exchangeProperty("CamelReceivedTimestamp").convertTo(Long.TYPE).isGreaterThan((Object)(new Date().getTime() + 3000L))});
        this.writeSlowFile();
        this.assertMockEndpointsSatisfied();
        String content = (String)this.context.getTypeConverter().convertTo(String.class, (Object)new File("target/changed/out/slowfile.dat"));
        String[] lines = content.split(LS);
        FileChangedReadLockMinAgeTest.assertEquals((String)"There should be 20 lines in the file", (int)20, (int)lines.length);
        for (int i = 0; i < 20; ++i) {
            FileChangedReadLockMinAgeTest.assertEquals((String)("Line " + i), (String)lines[i]);
        }
    }

    private void writeSlowFile() throws Exception {
        LOG.debug("Writing slow file...");
        FileOutputStream fos = new FileOutputStream("target/changed/in/slowfile.dat");
        for (int i = 0; i < 20; ++i) {
            fos.write(("Line " + i + LS).getBytes());
            LOG.debug("Writing line " + i);
            Thread.sleep(100L);
        }
        fos.flush();
        fos.close();
        LOG.debug("Writing slow file DONE...");
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("file:target/changed/in?readLock=changed&readLockMinAge=3000&readLockTimeout=1500").to(new String[]{"file:target/changed/out", "mock:result"});
            }
        };
    }
}

