/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.log;

import java.io.StringWriter;
import java.io.Writer;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.apache.log4j.WriterAppender;

public class LogBodyWithNewLineTest
extends ContextTestSupport {
    private StringWriter writer;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.writer = new StringWriter();
        WriterAppender appender = new WriterAppender((Layout)new SimpleLayout(), (Writer)this.writer);
        appender.setImmediateFlush(true);
        Logger logger = Logger.getRootLogger();
        logger.addAppender((Appender)appender);
        logger.setLevel(Level.INFO);
    }

    public void testNoSkip() throws Exception {
        String ls = System.getProperty("line.separator");
        String body = "1" + ls + "2" + ls + "3";
        this.template.sendBody("direct:start", (Object)body);
        this.log.info("{}", (Object)this.writer);
        LogBodyWithNewLineTest.assertTrue((boolean)this.writer.toString().contains(body));
    }

    public void testSkip() throws Exception {
        String ls = System.getProperty("line.separator");
        String body = "1" + ls + "2" + ls + "3";
        this.template.sendBody("direct:skip", (Object)body);
        this.log.info("{}", (Object)this.writer);
        LogBodyWithNewLineTest.assertTrue((boolean)this.writer.toString().contains("123"));
    }

    @Override
    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("direct:start").to("log:logger_name?level=INFO&showAll=true&skipBodyLineSeparator=false");
                this.from("direct:skip").to("log:logger_name?level=INFO&showAll=true&skipBodyLineSeparator=true");
            }
        };
    }
}

