/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mock;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.builder.xml.XPathBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.JndiRegistry;
import org.apache.camel.model.RouteDefinition;

public class MockEndpointTest
extends ContextTestSupport {
    public void testAscendingMessagesPass() throws Exception {
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.expectsAscending((Expression)MockEndpointTest.header("counter").convertTo(Number.class));
        this.sendMessages(11, 12, 13, 14, 15);
        resultEndpoint.assertIsSatisfied();
    }

    public void testAscendingMessagesFail() throws Exception {
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.expectsAscending((Expression)MockEndpointTest.header("counter").convertTo(Number.class));
        this.sendMessages(11, 12, 13, 15, 14);
        resultEndpoint.assertIsNotSatisfied();
    }

    public void testDescendingMessagesPass() throws Exception {
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.expectsDescending((Expression)MockEndpointTest.header("counter").convertTo(Number.class));
        this.sendMessages(15, 14, 13, 12, 11);
        resultEndpoint.assertIsSatisfied();
    }

    public void testDescendingMessagesFail() throws Exception {
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.expectsDescending((Expression)MockEndpointTest.header("counter").convertTo(Number.class));
        this.sendMessages(15, 14, 13, 11, 12);
        resultEndpoint.assertIsNotSatisfied();
    }

    public void testExpectsBodiesInOrder() throws Exception {
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.expectedBodiesReceived(this.listOfMessages(11, 12, 13, 14, 15));
        this.sendMessages(11, 12, 13, 14, 15);
        resultEndpoint.assertIsSatisfied();
    }

    public void testExpectsBodiesInAnyOrder() throws Exception {
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.expectedBodiesReceivedInAnyOrder(this.listOfMessages(11, 12, 13, 14, 15));
        this.sendMessages(15, 12, 14, 13, 11);
        resultEndpoint.assertIsSatisfied();
    }

    public void testExpectsBodiesInAnyOrderWithDuplicates() throws Exception {
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.expectedBodiesReceivedInAnyOrder(this.listOfMessages(11, 15, 12, 12, 13, 14, 15, 15));
        this.sendMessages(15, 15, 12, 14, 13, 12, 15, 11);
        resultEndpoint.assertIsSatisfied();
    }

    public void testExpectsHeadersInAnyOrder() throws Exception {
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.expectedHeaderValuesReceivedInAnyOrder("counter", new Object[]{11, 12, 13, 14, 15});
        this.sendMessages(15, 12, 14, 13, 11);
        resultEndpoint.assertIsSatisfied();
    }

    public void testExpectsHeadersInAnyOrderFail() throws Exception {
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.expectedHeaderValuesReceivedInAnyOrder("counter", new Object[]{11, 12, 7, 14, 15});
        this.sendMessages(15, 12, 14, 13, 11);
        try {
            resultEndpoint.assertIsSatisfied();
            MockEndpointTest.fail((String)"Should fail");
        }
        catch (AssertionError e) {
            MockEndpointTest.assertEquals((String)"mock://result Expected 5 headers with key[counter], received 4 headers. Expected header values: [7]", (String)((Throwable)((Object)e)).getMessage());
        }
    }

    public void testNoDuplicateMessagesPass() throws Exception {
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.expectsNoDuplicates((Expression)MockEndpointTest.header("counter"));
        this.sendMessages(11, 12, 13, 14, 15);
        resultEndpoint.assertIsSatisfied();
    }

    public void testDuplicateMessagesFail() throws Exception {
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.expectsNoDuplicates((Expression)MockEndpointTest.header("counter"));
        this.sendMessages(11, 12, 13, 14, 12);
        resultEndpoint.assertIsNotSatisfied();
    }

    public void testExpectationsAfterMessagesArrivePass() throws Exception {
        this.sendMessages(11, 12, 13, 14, 12);
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.expectedMessageCount(5);
        resultEndpoint.assertIsSatisfied();
    }

    public void testExpectationsAfterMessagesArriveFail() throws Exception {
        this.sendMessages(11, 12, 13, 14, 12);
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.expectedMessageCount(6);
        resultEndpoint.setResultWaitTime(2000L);
        resultEndpoint.assertIsNotSatisfied();
    }

    public void testReset() throws Exception {
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.expectedMessageCount(2);
        this.sendMessages(11, 12);
        resultEndpoint.assertIsSatisfied();
        resultEndpoint.reset();
        resultEndpoint.expectedMessageCount(3);
        this.sendMessages(11, 12, 13);
        resultEndpoint.assertIsSatisfied();
    }

    public void testExpectationOfHeader() throws InterruptedException {
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.reset();
        resultEndpoint.expectedHeaderReceived("header", (Object)"value");
        this.sendHeader("header", "value");
        resultEndpoint.assertIsSatisfied();
        resultEndpoint.reset();
        resultEndpoint.expectedHeaderReceived("header", (Object)"value1");
        this.sendHeader("header", "value");
        resultEndpoint.assertIsNotSatisfied();
        resultEndpoint.reset();
        resultEndpoint.expectedHeaderReceived("header1", (Object)"value");
        this.sendHeader("header", "value");
        resultEndpoint.assertIsNotSatisfied();
        resultEndpoint.reset();
        resultEndpoint.expectedHeaderReceived("header1", (Object)"value1");
        this.sendHeader("header", "value");
        resultEndpoint.assertIsNotSatisfied();
    }

    public void testExpectationOfHeaderWithNumber() throws InterruptedException {
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.reset();
        resultEndpoint.expectedHeaderReceived("number", (Object)123);
        this.sendHeader("number", 123);
        resultEndpoint.assertIsSatisfied();
    }

    public void testExpressionExpectationOfHeader() throws InterruptedException {
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.reset();
        resultEndpoint.expectedHeaderReceived("number", (Object)123);
        this.template.sendBodyAndHeader("direct:a", (Object)"<foo><id>123</id></foo>", "number", (Object)XPathBuilder.xpath((String)"/foo/id", Integer.class));
        resultEndpoint.assertIsSatisfied();
    }

    public void testExpressionExpectationOfProperty() throws InterruptedException {
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        resultEndpoint.reset();
        resultEndpoint.expectedPropertyReceived("number", (Object)123);
        this.template.sendBodyAndProperty("direct:a", (Object)"<foo><id>123</id></foo>", "number", (Object)XPathBuilder.xpath((String)"/foo/id", Integer.class));
        resultEndpoint.assertIsSatisfied();
    }

    public void testAscending() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectsAscending().body();
        mock.expectsAscending().header("counter");
        this.sendMessages(1, 2, 3, 4, 5);
        this.assertMockEndpointsSatisfied();
    }

    public void testAscendingFailed() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectsAscending().body();
        mock.expectsAscending().header("counter");
        this.sendMessages(1, 2, 5, 3, 4);
        mock.assertIsNotSatisfied();
    }

    public void testDescending() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectsDescending().body();
        mock.expectsDescending().header("counter");
        this.sendMessages(5, 4, 3, 2, 1);
        this.assertMockEndpointsSatisfied();
    }

    public void testDescendingFaied() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectsDescending().body();
        mock.expectsDescending().header("counter");
        this.sendMessages(5, 4, 2, 3, 1);
        mock.assertIsNotSatisfied();
    }

    public void testNoDuplicates() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectsNoDuplicates().body();
        mock.expectsNoDuplicates().header("counter");
        this.sendMessages(1, 2, 3, 4, 5);
        this.assertMockEndpointsSatisfied();
    }

    public void testNoDuplicatesFaied() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectsNoDuplicates().body();
        mock.expectsNoDuplicates().header("counter");
        this.sendMessages(1, 2, 5, 2, 4);
        mock.assertIsNotSatisfied();
    }

    public void testBody() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodyReceived().constant((Object)"<message>1</message>");
        this.sendMessages(1);
        mock.assertIsSatisfied();
    }

    public void testBodyTransformed() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodyReceived().method("foo", "greet");
        this.template.sendBody("direct:b", (Object)"Hello");
        mock.assertIsSatisfied();
    }

    public void testBodyFailed() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodyReceived().constant((Object)"<message>2</message>");
        this.sendMessages(1);
        mock.assertIsNotSatisfied();
    }

    public void testSimulateError() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.whenAnyExchangeReceived(new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.setException((Throwable)new IllegalArgumentException("Forced"));
            }
        });
        try {
            this.template.sendBody("direct:a", (Object)"Hello World");
            MockEndpointTest.fail((String)"Should have thrown an exception");
        }
        catch (Exception e) {
            MockEndpointTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
            MockEndpointTest.assertEquals((String)"Forced", (String)e.getCause().getMessage());
        }
    }

    public void testSimulateErrorByThrowingException() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.whenAnyExchangeReceived(new Processor(){

            public void process(Exchange exchange) throws Exception {
                throw new IllegalArgumentException("Forced");
            }
        });
        try {
            this.template.sendBody("direct:a", (Object)"Hello World");
            MockEndpointTest.fail((String)"Should have thrown an exception");
        }
        catch (Exception e) {
            MockEndpointTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
            MockEndpointTest.assertEquals((String)"Forced", (String)e.getCause().getMessage());
        }
    }

    public void testSimulateErrorWithIndex() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(2);
        mock.whenExchangeReceived(2, new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.setException((Throwable)new IllegalArgumentException("Forced"));
            }
        });
        this.template.sendBody("direct:a", (Object)"Hello World");
        try {
            this.template.sendBody("direct:a", (Object)"Hello World");
            MockEndpointTest.fail((String)"Should have thrown an exception");
        }
        catch (Exception e) {
            MockEndpointTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
            MockEndpointTest.assertEquals((String)"Forced", (String)e.getCause().getMessage());
        }
    }

    public void testSimulateErrorWithIndexByThrowingException() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(2);
        mock.whenExchangeReceived(2, new Processor(){

            public void process(Exchange exchange) throws Exception {
                throw new IllegalArgumentException("Forced");
            }
        });
        this.template.sendBody("direct:a", (Object)"Hello World");
        try {
            this.template.sendBody("direct:a", (Object)"Bye World");
            MockEndpointTest.fail((String)"Should have thrown an exception");
        }
        catch (Exception e) {
            MockEndpointTest.assertIsInstanceOf(IllegalArgumentException.class, e.getCause());
            MockEndpointTest.assertEquals((String)"Forced", (String)e.getCause().getMessage());
        }
    }

    public void testMinimumCount() throws Exception {
        MockEndpoint mock = MockEndpoint.resolve((CamelContext)this.context, (String)"mock:result");
        mock.expectedMinimumMessageCount(2);
        this.sendMessages(3, 4, 5);
        mock.assertIsSatisfied();
        MockEndpointTest.assertEquals((int)2, (int)mock.getExpectedMinimumCount());
    }

    public void testResolve() throws Exception {
        MockEndpoint mock = MockEndpoint.resolve((CamelContext)this.context, (String)"mock:result");
        mock.expectedMessageCount(2);
        mock.setResultWaitTime(500L);
        this.template.sendBody("direct:a", (Object)"Hello World");
        mock.assertIsNotSatisfied();
        MockEndpointTest.assertEquals((long)500L, (long)mock.getResultWaitTime());
    }

    public void testResolveTimeout() throws Exception {
        MockEndpoint mock = MockEndpoint.resolve((CamelContext)this.context, (String)"mock:result");
        mock.expectedMessageCount(2);
        mock.setResultWaitTime(500L);
        mock.assertIsNotSatisfied(1000L);
        MockEndpointTest.assertEquals((int)2, (int)mock.getExpectedCount());
        MockEndpointTest.assertEquals((long)500L, (long)mock.getResultWaitTime());
    }

    public void testSleepForEmptyTest() throws Exception {
        MockEndpoint mock = MockEndpoint.resolve((CamelContext)this.context, (String)"mock:result");
        mock.expectedMessageCount(0);
        mock.setSleepForEmptyTest(500L);
        mock.assertIsSatisfied();
        MockEndpointTest.assertEquals((int)0, (int)mock.getExpectedCount());
        MockEndpointTest.assertEquals((long)500L, (long)mock.getSleepForEmptyTest());
    }

    public void testSleepForEmptyTestAssert() throws Exception {
        MockEndpoint mock = MockEndpoint.resolve((CamelContext)this.context, (String)"mock:result");
        mock.expectedMessageCount(0);
        mock.assertIsSatisfied(400L);
        MockEndpointTest.assertEquals((int)0, (int)mock.getExpectedCount());
        MockEndpointTest.assertEquals((long)0L, (long)mock.getSleepForEmptyTest());
        MockEndpointTest.assertEquals((long)0L, (long)mock.getResultWaitTime());
    }

    public void testReporter() throws Exception {
        final AtomicBoolean reported = new AtomicBoolean(false);
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.setExpectedMessageCount(1);
        mock.setReporter(new Processor(){

            public void process(Exchange exchange) throws Exception {
                reported.set(true);
            }
        });
        this.template.sendBody("direct:a", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        MockEndpointTest.assertNotNull((Object)mock.getReporter());
        MockEndpointTest.assertTrue((boolean)reported.get());
    }

    public void testNoArgCtr() {
        MockEndpoint mock = new MockEndpoint();
        mock.setCamelContext((CamelContext)this.context);
        mock.setEndpointUriIfNotSpecified("mock:bar");
        try {
            mock.createConsumer(null);
            MockEndpointTest.fail((String)"Should have thrown an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        MockEndpointTest.assertEquals((int)0, (int)mock.getFailures().size());
    }

    public void testHeaderMissing() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedHeaderReceived("foo", (Object)123);
        mock.expectedHeaderReceived("bar", (Object)"cheese");
        this.template.sendBodyAndHeader("direct:a", (Object)"Hello World", "foo", (Object)123);
        try {
            this.assertMockEndpointsSatisfied();
            MockEndpointTest.fail((String)"Should have thrown exception");
        }
        catch (AssertionError e) {
            MockEndpointTest.assertEquals((String)"mock://result No header with name bar found for message: 0", (String)((Throwable)((Object)e)).getMessage());
        }
    }

    public void testHeaderInvalidValue() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedHeaderReceived("bar", (Object)"cheese");
        this.template.sendBodyAndHeader("direct:a", (Object)"Hello World", "bar", (Object)"beer");
        try {
            this.assertMockEndpointsSatisfied();
            MockEndpointTest.fail((String)"Should have thrown exception");
        }
        catch (AssertionError e) {
            MockEndpointTest.assertEquals((String)"mock://result Header with name bar for message: 0. Expected: <cheese> but was: <beer>", (String)((Throwable)((Object)e)).getMessage());
        }
    }

    public void testPropertyMissing() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedPropertyReceived("foo", (Object)123);
        mock.expectedPropertyReceived("bar", (Object)"cheese");
        this.template.sendBodyAndProperty("direct:a", (Object)"Hello World", "foo", (Object)123);
        try {
            this.assertMockEndpointsSatisfied();
            MockEndpointTest.fail((String)"Should have thrown exception");
        }
        catch (AssertionError e) {
            MockEndpointTest.assertEquals((String)"mock://result No property with name bar found for message: 0", (String)((Throwable)((Object)e)).getMessage());
        }
    }

    public void testPropertyInvalidValue() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedPropertyReceived("bar", (Object)"cheese");
        this.template.sendBodyAndProperty("direct:a", (Object)"Hello World", "bar", (Object)"beer");
        try {
            this.assertMockEndpointsSatisfied();
            MockEndpointTest.fail((String)"Should have thrown exception");
        }
        catch (AssertionError e) {
            MockEndpointTest.assertEquals((String)"mock://result Property with name bar for message: 0. Expected: <cheese> but was: <beer>", (String)((Throwable)((Object)e)).getMessage());
        }
    }

    public void testMessageIndexIsEqualTo() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(2);
        ((ValueBuilder)mock.message(0).header("foo")).isEqualTo((Object)123);
        ((ValueBuilder)mock.message(1).header("bar")).isEqualTo((Object)444);
        this.template.sendBodyAndHeader("direct:a", (Object)"Hello World", "foo", (Object)123);
        this.template.sendBodyAndHeader("direct:a", (Object)"Hello World", "bar", (Object)234);
        try {
            this.assertMockEndpointsSatisfied();
            MockEndpointTest.fail((String)"Should have thrown exception");
        }
        catch (AssertionError e) {
            String s = "Assertion error at index 1 on mock mock://result with predicate: header(bar) == 444 evaluated as: 234 == 444";
            MockEndpointTest.assertTrue((boolean)((Throwable)((Object)e)).getMessage().startsWith(s));
        }
    }

    public void testPredicateEvaluationIsNull() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(2);
        ((ValueBuilder)mock.message(0).header("foo")).isNotNull();
        ((ValueBuilder)mock.message(1).header("bar")).isNull();
        this.template.sendBodyAndHeader("direct:a", (Object)"Hello World", "foo", (Object)123);
        this.template.sendBodyAndHeader("direct:a", (Object)"Hello World", "bar", (Object)234);
        try {
            this.assertMockEndpointsSatisfied();
            MockEndpointTest.fail((String)"Should have thrown exception");
        }
        catch (AssertionError e) {
            String s = "Assertion error at index 1 on mock mock://result with predicate: header(bar) is null evaluated as: 234 is null";
            MockEndpointTest.assertTrue((boolean)((Throwable)((Object)e)).getMessage().startsWith(s));
        }
    }

    public void testPredicateEvaluationIsInstanceOf() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(2);
        ((ValueBuilder)mock.message(0).header("foo")).isNotNull();
        ((ValueBuilder)mock.message(1).header("bar")).isInstanceOf(String.class);
        this.template.sendBodyAndHeader("direct:a", (Object)"Hello World", "foo", (Object)123);
        this.template.sendBodyAndHeader("direct:a", (Object)"Hello World", "bar", (Object)234);
        try {
            this.assertMockEndpointsSatisfied();
            MockEndpointTest.fail((String)"Should have thrown exception");
        }
        catch (AssertionError e) {
            String s = "Assertion error at index 1 on mock mock://result with predicate: header(bar) instanceof java.lang.String";
            MockEndpointTest.assertTrue((boolean)((Throwable)((Object)e)).getMessage().startsWith(s));
        }
    }

    public void testExchangePattern() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(2);
        ((ValueBuilder)mock.message(0).exchangePattern()).isEqualTo((Object)ExchangePattern.InOnly);
        ((ValueBuilder)mock.message(1).exchangePattern()).isEqualTo((Object)ExchangePattern.InOut);
        this.template.sendBody("direct:a", (Object)"Hello World");
        this.template.requestBody("direct:a", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
    }

    public void testExpectedExchangePattern() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedExchangePattern(ExchangePattern.InOnly);
        this.template.sendBody("direct:a", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        this.resetMocks();
        mock.expectedMessageCount(1);
        mock.expectedExchangePattern(ExchangePattern.InOut);
        this.template.requestBody("direct:a", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
    }

    public void testSetMultipleExpectedHeaders() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedHeaderReceived("foo", (Object)123);
        mock.expectedHeaderReceived("bar", (Object)"beer");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("foo", 123);
        map.put("bar", "beer");
        this.template.sendBodyAndHeaders("direct:a", (Object)"Hello World", map);
        mock.assertIsSatisfied();
    }

    public void testSetMultipleExpectedHeaders2() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(2);
        mock.expectedHeaderReceived("foo", (Object)123);
        mock.expectedHeaderReceived("bar", (Object)"beer");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("foo", 123);
        map.put("bar", "beer");
        this.template.sendBodyAndHeaders("direct:a", (Object)"Hello World", map);
        this.template.sendBodyAndHeaders("direct:a", (Object)"Hello World", map);
        mock.assertIsSatisfied();
    }

    public void testSetMultipleExpectedHeaders3() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedHeaderReceived("foo", (Object)123);
        mock.expectedHeaderReceived("bar", null);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("foo", 123);
        this.template.sendBodyAndHeaders("direct:a", (Object)"Hello World", map);
        mock.assertIsSatisfied();
    }

    public void testSetMultipleExpectedHeaders4() throws Exception {
        ByteArrayInputStream is = new ByteArrayInputStream("Test".getBytes());
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedHeaderReceived("foo", (Object)123);
        mock.expectedHeaderReceived("bar", (Object)"Test");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("foo", 123);
        map.put("bar", is);
        this.template.sendBodyAndHeaders("direct:a", (Object)"Hello World", map);
        mock.assertIsSatisfied();
    }

    public void testSetMultipleExpectedHeadersShouldFail() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedHeaderReceived("foo", (Object)123);
        mock.expectedHeaderReceived("bar", (Object)"beer");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("foo", 456);
        map.put("bar", "beer");
        this.template.sendBodyAndHeaders("direct:a", (Object)"Hello World", map);
        mock.assertIsNotSatisfied();
    }

    public void testSetMultipleExpectedHeadersShouldFail2() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedHeaderReceived("foo", (Object)123);
        mock.expectedHeaderReceived("bar", (Object)"beer");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("foo", 123);
        map.put("bar", "wine");
        this.template.sendBodyAndHeaders("direct:a", (Object)"Hello World", map);
        mock.assertIsNotSatisfied();
    }

    public void testSetMultipleExpectedHeadersShouldFail3() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(2);
        mock.expectedHeaderReceived("foo", (Object)123);
        mock.expectedHeaderReceived("bar", (Object)"beer");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("foo", 123);
        map.put("bar", "beer");
        this.template.sendBodyAndHeaders("direct:a", (Object)"Hello World", map);
        map = new HashMap();
        map.put("foo", 123);
        map.put("bar", "wine");
        this.template.sendBodyAndHeaders("direct:a", (Object)"Hello World", map);
        mock.assertIsNotSatisfied();
    }

    public void testSetMultipleExpectedProperties() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedPropertyReceived("foo", (Object)123);
        mock.expectedPropertyReceived("bar", (Object)"beer");
        this.template.send("direct:a", new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.setProperty("foo", (Object)123);
                exchange.setProperty("bar", (Object)"beer");
            }
        });
        mock.assertIsSatisfied();
    }

    public void testSetMultipleExpectedProperties2() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(2);
        mock.expectedPropertyReceived("foo", (Object)123);
        mock.expectedPropertyReceived("bar", (Object)"beer");
        this.template.send("direct:a", new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.setProperty("foo", (Object)123);
                exchange.setProperty("bar", (Object)"beer");
            }
        });
        this.template.send("direct:a", new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.setProperty("foo", (Object)123);
                exchange.setProperty("bar", (Object)"beer");
            }
        });
        mock.assertIsSatisfied();
    }

    public void testSetMultipleExpectedProperties3() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedPropertyReceived("foo", (Object)123);
        mock.expectedPropertyReceived("bar", null);
        this.template.send("direct:a", new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.setProperty("foo", (Object)123);
            }
        });
        mock.assertIsSatisfied();
    }

    public void testSetMultipleExpectedPropertiesShouldFail() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedPropertyReceived("foo", (Object)123);
        mock.expectedPropertyReceived("bar", (Object)"beer");
        this.template.send("direct:a", new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.setProperty("foo", (Object)456);
                exchange.setProperty("bar", (Object)"beer");
            }
        });
        mock.assertIsNotSatisfied();
    }

    public void testSetMultipleExpectedPropertiesShouldFail2() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        mock.expectedPropertyReceived("foo", (Object)123);
        mock.expectedPropertyReceived("bar", (Object)"beer");
        this.template.send("direct:a", new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.setProperty("foo", (Object)123);
                exchange.setProperty("bar", (Object)"wine");
            }
        });
        mock.assertIsNotSatisfied();
    }

    public void testSetMultipleExpectedPropertiesShouldFail3() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(2);
        mock.expectedPropertyReceived("foo", (Object)123);
        mock.expectedPropertyReceived("bar", (Object)"beer");
        this.template.send("direct:a", new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.setProperty("foo", (Object)123);
                exchange.setProperty("bar", (Object)"beer");
            }
        });
        this.template.send("direct:a", new Processor(){

            public void process(Exchange exchange) throws Exception {
                exchange.setProperty("foo", (Object)123);
                exchange.setProperty("bar", (Object)"wine");
            }
        });
        mock.assertIsNotSatisfied();
    }

    public void testExpectedBodyTypeCoerce() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{987});
        this.template.sendBody("direct:a", (Object)"0987");
        this.assertMockEndpointsSatisfied();
    }

    public void testExpectedBodyExpression() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{987});
        this.template.sendBody("direct:a", (Object)ExpressionBuilder.constantExpression((Object)"0987"));
        this.assertMockEndpointsSatisfied();
    }

    public void testResetDefaultProcessor() throws Exception {
        final AtomicInteger counter = new AtomicInteger();
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.whenAnyExchangeReceived(new Processor(){

            public void process(Exchange exchange) throws Exception {
                counter.incrementAndGet();
            }
        });
        mock.expectedMessageCount(1);
        this.sendMessages(1);
        mock.assertIsSatisfied();
        MockEndpointTest.assertEquals((int)1, (int)counter.get());
        this.resetMocks();
        mock.expectedMessageCount(1);
        this.sendMessages(1);
        mock.assertIsSatisfied();
        MockEndpointTest.assertEquals((int)1, (int)counter.get());
    }

    public void testRetainFirst() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.setRetainFirst(5);
        mock.expectedMessageCount(10);
        this.sendMessages(0, 1, 2, 3, 4, 5, 6, 7, 8, 9);
        this.assertMockEndpointsSatisfied();
        MockEndpointTest.assertEquals((int)10, (int)mock.getReceivedCounter());
        MockEndpointTest.assertEquals((int)5, (int)mock.getExchanges().size());
        MockEndpointTest.assertEquals((int)5, (int)mock.getReceivedExchanges().size());
        MockEndpointTest.assertEquals((Object)"<message>0</message>", (Object)((Exchange)mock.getReceivedExchanges().get(0)).getIn().getBody());
        MockEndpointTest.assertEquals((Object)"<message>1</message>", (Object)((Exchange)mock.getReceivedExchanges().get(1)).getIn().getBody());
        MockEndpointTest.assertEquals((Object)"<message>2</message>", (Object)((Exchange)mock.getReceivedExchanges().get(2)).getIn().getBody());
        MockEndpointTest.assertEquals((Object)"<message>3</message>", (Object)((Exchange)mock.getReceivedExchanges().get(3)).getIn().getBody());
        MockEndpointTest.assertEquals((Object)"<message>4</message>", (Object)((Exchange)mock.getReceivedExchanges().get(4)).getIn().getBody());
    }

    public void testRetainLast() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.setRetainLast(5);
        mock.expectedMessageCount(10);
        this.sendMessages(0, 1, 2, 3, 4, 5, 6, 7, 8, 9);
        this.assertMockEndpointsSatisfied();
        MockEndpointTest.assertEquals((int)10, (int)mock.getReceivedCounter());
        MockEndpointTest.assertEquals((int)5, (int)mock.getExchanges().size());
        MockEndpointTest.assertEquals((int)5, (int)mock.getReceivedExchanges().size());
        MockEndpointTest.assertEquals((Object)"<message>5</message>", (Object)((Exchange)mock.getReceivedExchanges().get(0)).getIn().getBody());
        MockEndpointTest.assertEquals((Object)"<message>6</message>", (Object)((Exchange)mock.getReceivedExchanges().get(1)).getIn().getBody());
        MockEndpointTest.assertEquals((Object)"<message>7</message>", (Object)((Exchange)mock.getReceivedExchanges().get(2)).getIn().getBody());
        MockEndpointTest.assertEquals((Object)"<message>8</message>", (Object)((Exchange)mock.getReceivedExchanges().get(3)).getIn().getBody());
        MockEndpointTest.assertEquals((Object)"<message>9</message>", (Object)((Exchange)mock.getReceivedExchanges().get(4)).getIn().getBody());
    }

    public void testRetainFirstAndLast() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.setRetainFirst(5);
        mock.setRetainLast(5);
        mock.expectedMessageCount(20);
        this.sendMessages(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19);
        this.assertMockEndpointsSatisfied();
        MockEndpointTest.assertEquals((int)20, (int)mock.getReceivedCounter());
        MockEndpointTest.assertEquals((int)10, (int)mock.getExchanges().size());
        MockEndpointTest.assertEquals((int)10, (int)mock.getReceivedExchanges().size());
        MockEndpointTest.assertEquals((Object)"<message>0</message>", (Object)((Exchange)mock.getReceivedExchanges().get(0)).getIn().getBody());
        MockEndpointTest.assertEquals((Object)"<message>1</message>", (Object)((Exchange)mock.getReceivedExchanges().get(1)).getIn().getBody());
        MockEndpointTest.assertEquals((Object)"<message>2</message>", (Object)((Exchange)mock.getReceivedExchanges().get(2)).getIn().getBody());
        MockEndpointTest.assertEquals((Object)"<message>3</message>", (Object)((Exchange)mock.getReceivedExchanges().get(3)).getIn().getBody());
        MockEndpointTest.assertEquals((Object)"<message>4</message>", (Object)((Exchange)mock.getReceivedExchanges().get(4)).getIn().getBody());
        MockEndpointTest.assertEquals((Object)"<message>15</message>", (Object)((Exchange)mock.getReceivedExchanges().get(5)).getIn().getBody());
        MockEndpointTest.assertEquals((Object)"<message>16</message>", (Object)((Exchange)mock.getReceivedExchanges().get(6)).getIn().getBody());
        MockEndpointTest.assertEquals((Object)"<message>17</message>", (Object)((Exchange)mock.getReceivedExchanges().get(7)).getIn().getBody());
        MockEndpointTest.assertEquals((Object)"<message>18</message>", (Object)((Exchange)mock.getReceivedExchanges().get(8)).getIn().getBody());
        MockEndpointTest.assertEquals((Object)"<message>19</message>", (Object)((Exchange)mock.getReceivedExchanges().get(9)).getIn().getBody());
    }

    public void testRetainFirstAndLastOverlap() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.setRetainFirst(5);
        mock.setRetainLast(5);
        mock.expectedMessageCount(8);
        this.sendMessages(0, 1, 2, 3, 4, 5, 6, 7);
        this.assertMockEndpointsSatisfied();
        MockEndpointTest.assertEquals((int)8, (int)mock.getReceivedCounter());
        MockEndpointTest.assertEquals((int)8, (int)mock.getExchanges().size());
        MockEndpointTest.assertEquals((int)8, (int)mock.getReceivedExchanges().size());
        MockEndpointTest.assertEquals((Object)"<message>0</message>", (Object)((Exchange)mock.getReceivedExchanges().get(0)).getIn().getBody());
        MockEndpointTest.assertEquals((Object)"<message>1</message>", (Object)((Exchange)mock.getReceivedExchanges().get(1)).getIn().getBody());
        MockEndpointTest.assertEquals((Object)"<message>2</message>", (Object)((Exchange)mock.getReceivedExchanges().get(2)).getIn().getBody());
        MockEndpointTest.assertEquals((Object)"<message>3</message>", (Object)((Exchange)mock.getReceivedExchanges().get(3)).getIn().getBody());
        MockEndpointTest.assertEquals((Object)"<message>4</message>", (Object)((Exchange)mock.getReceivedExchanges().get(4)).getIn().getBody());
        MockEndpointTest.assertEquals((Object)"<message>5</message>", (Object)((Exchange)mock.getReceivedExchanges().get(5)).getIn().getBody());
        MockEndpointTest.assertEquals((Object)"<message>6</message>", (Object)((Exchange)mock.getReceivedExchanges().get(6)).getIn().getBody());
        MockEndpointTest.assertEquals((Object)"<message>7</message>", (Object)((Exchange)mock.getReceivedExchanges().get(7)).getIn().getBody());
    }

    public void testRetainFirstAndLastNoGap() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.setRetainFirst(5);
        mock.setRetainLast(5);
        mock.expectedMessageCount(10);
        this.sendMessages(0, 1, 2, 3, 4, 5, 6, 7, 8, 9);
        this.assertMockEndpointsSatisfied();
        MockEndpointTest.assertEquals((int)10, (int)mock.getReceivedCounter());
        MockEndpointTest.assertEquals((int)10, (int)mock.getExchanges().size());
        MockEndpointTest.assertEquals((int)10, (int)mock.getReceivedExchanges().size());
        MockEndpointTest.assertEquals((Object)"<message>0</message>", (Object)((Exchange)mock.getReceivedExchanges().get(0)).getIn().getBody());
        MockEndpointTest.assertEquals((Object)"<message>1</message>", (Object)((Exchange)mock.getReceivedExchanges().get(1)).getIn().getBody());
        MockEndpointTest.assertEquals((Object)"<message>2</message>", (Object)((Exchange)mock.getReceivedExchanges().get(2)).getIn().getBody());
        MockEndpointTest.assertEquals((Object)"<message>3</message>", (Object)((Exchange)mock.getReceivedExchanges().get(3)).getIn().getBody());
        MockEndpointTest.assertEquals((Object)"<message>4</message>", (Object)((Exchange)mock.getReceivedExchanges().get(4)).getIn().getBody());
        MockEndpointTest.assertEquals((Object)"<message>5</message>", (Object)((Exchange)mock.getReceivedExchanges().get(5)).getIn().getBody());
        MockEndpointTest.assertEquals((Object)"<message>6</message>", (Object)((Exchange)mock.getReceivedExchanges().get(6)).getIn().getBody());
        MockEndpointTest.assertEquals((Object)"<message>7</message>", (Object)((Exchange)mock.getReceivedExchanges().get(7)).getIn().getBody());
        MockEndpointTest.assertEquals((Object)"<message>8</message>", (Object)((Exchange)mock.getReceivedExchanges().get(8)).getIn().getBody());
        MockEndpointTest.assertEquals((Object)"<message>9</message>", (Object)((Exchange)mock.getReceivedExchanges().get(9)).getIn().getBody());
    }

    public void testRetainFirstAndLastSingleGap() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.setRetainFirst(5);
        mock.setRetainLast(5);
        mock.expectedMessageCount(11);
        this.sendMessages(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10);
        this.assertMockEndpointsSatisfied();
        MockEndpointTest.assertEquals((int)11, (int)mock.getReceivedCounter());
        MockEndpointTest.assertEquals((int)10, (int)mock.getExchanges().size());
        MockEndpointTest.assertEquals((int)10, (int)mock.getReceivedExchanges().size());
        MockEndpointTest.assertEquals((Object)"<message>0</message>", (Object)((Exchange)mock.getReceivedExchanges().get(0)).getIn().getBody());
        MockEndpointTest.assertEquals((Object)"<message>1</message>", (Object)((Exchange)mock.getReceivedExchanges().get(1)).getIn().getBody());
        MockEndpointTest.assertEquals((Object)"<message>2</message>", (Object)((Exchange)mock.getReceivedExchanges().get(2)).getIn().getBody());
        MockEndpointTest.assertEquals((Object)"<message>3</message>", (Object)((Exchange)mock.getReceivedExchanges().get(3)).getIn().getBody());
        MockEndpointTest.assertEquals((Object)"<message>4</message>", (Object)((Exchange)mock.getReceivedExchanges().get(4)).getIn().getBody());
        MockEndpointTest.assertEquals((Object)"<message>6</message>", (Object)((Exchange)mock.getReceivedExchanges().get(5)).getIn().getBody());
        MockEndpointTest.assertEquals((Object)"<message>7</message>", (Object)((Exchange)mock.getReceivedExchanges().get(6)).getIn().getBody());
        MockEndpointTest.assertEquals((Object)"<message>8</message>", (Object)((Exchange)mock.getReceivedExchanges().get(7)).getIn().getBody());
        MockEndpointTest.assertEquals((Object)"<message>9</message>", (Object)((Exchange)mock.getReceivedExchanges().get(8)).getIn().getBody());
        MockEndpointTest.assertEquals((Object)"<message>10</message>", (Object)((Exchange)mock.getReceivedExchanges().get(9)).getIn().getBody());
    }

    protected void sendMessages(int ... counters) {
        for (int counter : counters) {
            this.template.sendBodyAndHeader("direct:a", (Object)this.createTestMessage(counter), "counter", (Object)counter);
        }
    }

    private String createTestMessage(int counter) {
        return "<message>" + counter + "</message>";
    }

    protected Object[] listOfMessages(int ... counters) {
        ArrayList<String> list = new ArrayList<String>(counters.length);
        for (int counter : counters) {
            list.add(this.createTestMessage(counter));
        }
        return list.toArray();
    }

    protected void sendHeader(String name, Object value) {
        this.template.sendBodyAndHeader("direct:a", (Object)"body", name, value);
    }

    @Override
    protected JndiRegistry createRegistry() throws Exception {
        JndiRegistry jndi = super.createRegistry();
        jndi.bind("foo", (Object)new MyHelloBean());
        return jndi;
    }

    @Override
    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:a").to("mock:result");
                ((RouteDefinition)this.from("direct:b").transform((Expression)this.body().append((Object)" World"))).to("mock:result");
            }
        };
    }

    public static final class MyHelloBean {
        public String greet() {
            return "Hello World";
        }
    }
}

